// Global Variables
var form;
var title;
var titleStatus;
var url;
var urlStatus;
var authorName;
var authorNameStatus;
var authorflag;
var authorBlog;
var authorBlogStatus;
var authorEmail;
var authorEmailStatus;
var published;
var publishedStatus;
var submitButton;

// Invoked on Body Loading-time
function init() {

  cacheDom();
  cacheImages();

  title.onkeyup = checkTitle;
  url.onkeyup = checkUrl;
  authorName.onkeyup = checkAuthorName;
  authorBlog.onkeyup = checkAuthorBlog;
  authorEmail.onkeyup = checkAuthorEmail;
  published.onkeyup = checkPublished;

  form.onsubmit = checkForm;

  authorflag = 'off';
  title.focus();
}

// Cache DOM
function cacheDom() {
  form = findElement('form');
  title = findElement('title');
  titleStatus = findElement('titleStatus');
  url = findElement('url');
  urlStatus = findElement('urlStatus');
  authorName = findElement('authorName');
  authorNameStatus = findElement('authorNameStatus');
  authorBlog = findElement('authorBlog');
  authorBlogStatus = findElement('authorBlogStatus');
  authorEmail = findElement('authorEmail');
  authorEmailStatus = findElement('authorEmailStatus');
  published = findElement('published');
  publishedStatus = findElement('publishedStatus');

  submitButton = findElement('submit');
}

// Cache Images
function cacheImages() {
  var errorImage = new Image();
  var successImage = new Image();

  errorImage.src = "../img/ico/invalid.png";
  successImage.src = "../img/ico/valid.png";
}

// Find Element By the id Attribute
function findElement(id){
	return document.getElementById(id);
}

// Check Fuctions
function checkTitle() {
  var filter = /.{7}/;
  if (filter.test(title.value)) {
    setSuccess(titleStatus);
    return true;
  } else {
    setError(titleStatus, '7글자 이상 입력하세요.');
    return false;
  }
}

function checkUrl(){
  var filter = /ht{2}p:\/\//;
  if (filter.test(url.value)){
  	setSuccess(urlStatus);
  	return true;
  }else{
  	setError(urlStatus, 'http:// 로 시작하도록 입력하세요.');
  	return false;
  }
}

function checkAuthorName(){
  var filter = /.{3}/;
  if (filter.test(authorName.value)) {
    setSuccess(authorNameStatus);
    enableAuthorInfoInput();
    return true;
  } else {
    setError(authorNameStatus, '3글자 이상 입력하세요.');
    disableAuthorInfoInput();
    return false;
  }
}

function enableAuthorInfoInput(){
  authorEmail.disabled = '';
  authorEmail.className = 'textfield';
  authorBlog.disabled = '';
  authorBlog.className = 'textfield';
  authorflag = 'on';
}

function disableAuthorInfoInput(){
  authorEmail.value = '';
  authorBlog.value = '';
  authorEmail.disabled = 'disabled';
  authorEmail.className = 'disabledTextfield';
  authorBlog.disabled = 'disabled';
  authorBlog.className = 'disabledTextfield';
  authorflag = 'off';
}

function checkAuthorBlog(){
  if (authorflag == 'off'){
  	return;
  }

  var filter = /ht{2}p:\/\//;
  if(authorBlog.value == ''){
  	setSuccess(authorBlogStatus, '필수 입력 항목은 아닙니다.');
  	return true;
  } else if (filter.test(authorBlog.value)){
  	setSuccess(authorBlogStatus);
  	return true;
  }else{
  	setError(authorBlogStatus, 'http:// 로 시작하도록 입력하세요.');
  	return false;
  }
}

function checkAuthorEmail(){
  if (authorflag == 'off'){
  	return;
  }

  var filter = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
   if(authorEmail.value == ''){
  	setSuccess(authorEmailStatus, '필수 입력 항목은 아닙니다.');
  	return true;
  } else if (filter.test(authorEmail.value)){
  	setSuccess(authorEmailStatus);
  	return true;
  }else{
  	setError(authorEmailStatus, '올바른 이메일 주소가 아닙니다.');
   	return false;
  }
}

function checkPublished(){
  var filter = /(199|200)[0-9]\/(01|02|03|04|05|06|07|08|09|10|11|12)\/(01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)/;
  if (filter.test(published.value)){
	setSuccess(publishedStatus);
	return true;
  }else{
  	setError(publishedStatus, 'YYYY/MM/DD 형태로 입력하세요.');
  	return false;
  }
}


function checkForm(){
  if(checkUrl() & checkTitle() & checkPublished() & checkAuthor()
  		& checkAuthorEmail() & checkAuthorBlog()){
  	return true;
  }else{
  	return false;
  }
}


// Print Messages
function setSuccess(element, msg) {
  element.innerHTML = '<span class="success_msg">' + (msg == null ? '&nbsp;' : msg) + '</span>';
  element.className = 'success';
}

function setError(element, msg) {
  element.innerHTML = '<span class="error_msg">' + (msg == null ? '&nbsp;' : msg) + '</span>';
  element.className = 'error';
}
