package ams.web.article;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

import ams.domain.article.Article;
import ams.service.article.IArticle;

public class ArticleDetailsController extends AbstractController {

	private IArticle articleFacade;

	public void setArticleFacade(IArticle articleFacade) {
		this.articleFacade = articleFacade;
	}

	@Override
	protected ModelAndView handleRequestInternal(HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		Integer id = Integer.parseInt(request.getParameter("id"));
		logger.debug("관리번호" + id + " 아티클에 대한 상세 정보 요청을 접수합니다.");

		Article article = articleFacade.getArticle(id);


		return new ModelAndView("article/details", "article", article);

	}

}
