package ams.service.admin.support;

import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import ams.domain.admin.Admin;
import ams.service.admin.IAdmin;

public class AdminLoginValidator implements Validator {

	private IAdmin adminFacade;

	public void setAdminFacade(IAdmin adminFacade) {
		this.adminFacade = adminFacade;
	}

	public boolean supports(Class clazz) {
		return clazz.equals(Admin.class);
	}

	public void validate(Object object, Errors errors) {
		Admin unidentified = (Admin) object;

		try {
			Admin identified = adminFacade.getAdmin(unidentified.getId(),
					unidentified.getPassword());
			if (identified == null)
				errors.rejectValue("id", "error.login.invalid-user", null,
						"잘못된 ID 입니다.");

		} catch (IllegalAdminPasswordException e) {
			errors.rejectValue("password", "error.login.invalid-password",
					null, "비밀번호가 잘못되었습니다.");
		}

	}

}
