
package ams.domain.form;

import java.util.Date;

import ams.domain.article.Article;
import ams.domain.article.Author;

/**
 * Transient 도메인 객체(비즈니스 타입)
 *
 */
public class ArticleRegistrationForm {

	private String title;

	private String url;

	private Date published;

	private String description;

	private String authorName;

	private String authorEmail;

	private String authorBlog;

	public String getAuthorBlog() {
		return authorBlog;
	}

	public void setAuthorBlog(String authorBlog) {
		this.authorBlog = authorBlog;
	}

	public String getAuthorEmail() {
		return authorEmail;
	}

	public void setAuthorEmail(String authorEmail) {
		this.authorEmail = authorEmail;
	}

	public String getAuthorName() {
		return authorName;
	}

	public void setAuthorName(String authorName) {
		this.authorName = authorName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getPublished() {
		return published;
	}

	public void setPublished(Date published) {
		this.published = published;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Article getArticle(){
		Article article = new Article();
		article.setTitle(title);
		article.setDescription(description);
		article.setPublished(published);
		article.setUrl(url);
		return article;
	}

	public Author getAuthor() {
		Author author = new Author();

		author.setName(this.authorName);

		// 블로그 정보 미기입시를 위한 처리
		if(authorBlog.equals(""))
			author.setBlog(Author.UNKNOWN);
		else
			author.setBlog(authorBlog);


		// 이메일 정보 미기입시를 위한 처리
		if(authorEmail.equals(""))
			author.setEmail(Author.UNKNOWN);
		else
			author.setEmail(authorEmail);

		return author;
	}

}
