/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMap;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMapping;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class AutoResultMap
extends BasicResultMap {
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$DomTypeMarker;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public AutoResultMap(SqlMapExecutorDelegate delegate, boolean allowRemapping) {
        super(delegate);
        this.allowRemapping = allowRemapping;
    }

    public synchronized Object[] getResults(RequestScope request, ResultSet rs) throws SQLException {
        if (this.allowRemapping || this.getResultMappings() == null) {
            this.initialize(rs);
        }
        return super.getResults(request, rs);
    }

    private void initialize(ResultSet rs) {
        if (this.getResultClass() == null) {
            throw new SqlMapException("The automatic ResultMap named " + this.getId() + " had a null result class (not allowed).");
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = AutoResultMap.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(this.getResultClass())) {
            this.initializeMapResults(rs);
        } else if (this.getDelegate().getTypeHandlerFactory().getTypeHandler(this.getResultClass()) != null) {
            this.initializePrimitiveResults(rs);
        } else if ((class$com$ibatis$sqlmap$engine$type$DomTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomTypeMarker = AutoResultMap.class$("com.ibatis.sqlmap.engine.type.DomTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomTypeMarker).isAssignableFrom(this.getResultClass())) {
            this.initializeXmlResults(rs);
        } else {
            this.initializeBeanResults(rs);
        }
    }

    private void initializeBeanResults(ResultSet rs) {
        try {
            ClassInfo classInfo = ClassInfo.getInstance((Class)this.getResultClass());
            String[] propertyNames = classInfo.getWriteablePropertyNames();
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            for (int i = 0; i < propertyNames.length; ++i) {
                propertyMap.put(propertyNames[i].toUpperCase(), propertyNames[i]);
            }
            ArrayList<BasicResultMapping> resultMappingList = new ArrayList<BasicResultMapping>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int n = rsmd.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String columnName = rsmd.getColumnLabel(i + 1);
                String upperColumnName = columnName.toUpperCase();
                String matchedProp = (String)propertyMap.get(upperColumnName);
                if (matchedProp == null) continue;
                BasicResultMapping resultMapping = new BasicResultMapping();
                resultMapping.setPropertyName(matchedProp);
                resultMapping.setColumnName(columnName);
                resultMapping.setColumnIndex(i + 1);
                Class type = classInfo.getSetterType(matchedProp);
                resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(type));
                resultMappingList.add(resultMapping);
            }
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new NestedRuntimeException("Error automapping columns. Cause: " + e);
        }
    }

    private void initializeXmlResults(ResultSet rs) {
        try {
            ArrayList<BasicResultMapping> resultMappingList = new ArrayList<BasicResultMapping>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int n = rsmd.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String columnName = rsmd.getColumnLabel(i + 1);
                BasicResultMapping resultMapping = new BasicResultMapping();
                resultMapping.setPropertyName(columnName);
                resultMapping.setColumnName(columnName);
                resultMapping.setColumnIndex(i + 1);
                resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(class$java$lang$String == null ? AutoResultMap.class$("java.lang.String") : class$java$lang$String));
                resultMappingList.add(resultMapping);
            }
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new NestedRuntimeException("Error automapping columns. Cause: " + e);
        }
    }

    private void initializeMapResults(ResultSet rs) {
        try {
            ArrayList<BasicResultMapping> resultMappingList = new ArrayList<BasicResultMapping>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int n = rsmd.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String columnName = rsmd.getColumnLabel(i + 1);
                BasicResultMapping resultMapping = new BasicResultMapping();
                resultMapping.setPropertyName(columnName);
                resultMapping.setColumnName(columnName);
                resultMapping.setColumnIndex(i + 1);
                resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(class$java$lang$Object == null ? AutoResultMap.class$("java.lang.Object") : class$java$lang$Object));
                resultMappingList.add(resultMapping);
            }
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new NestedRuntimeException("Error automapping columns. Cause: " + e);
        }
    }

    private void initializePrimitiveResults(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            String columnName = rsmd.getColumnLabel(1);
            BasicResultMapping resultMapping = new BasicResultMapping();
            resultMapping.setPropertyName(columnName);
            resultMapping.setColumnName(columnName);
            resultMapping.setColumnIndex(1);
            resultMapping.setTypeHandler(this.getDelegate().getTypeHandlerFactory().getTypeHandler(this.getResultClass()));
            ArrayList<BasicResultMapping> resultMappingList = new ArrayList<BasicResultMapping>();
            resultMappingList.add(resultMapping);
            this.setResultMappingList(resultMappingList);
        }
        catch (SQLException e) {
            throw new NestedRuntimeException("Error automapping columns. Cause: " + e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

