/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.filter;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.filter.BufferedResponseWrapper;
import org.displaytag.filter.SimpleServletOutputStream;

public class BufferedResponseWrapper12Impl
implements BufferedResponseWrapper {
    private static Log log = LogFactory.getLog((Class)(class$org$displaytag$filter$BufferedResponseWrapper12Impl == null ? (class$org$displaytag$filter$BufferedResponseWrapper12Impl = BufferedResponseWrapper12Impl.class$("org.displaytag.filter.BufferedResponseWrapper12Impl")) : class$org$displaytag$filter$BufferedResponseWrapper12Impl));
    private CharArrayWriter outputWriter;
    private SimpleServletOutputStream servletOutputStream;
    private String contentType;
    private HttpServletResponse response;
    private boolean state;
    private boolean outRequested;
    static /* synthetic */ Class class$org$displaytag$filter$BufferedResponseWrapper12Impl;

    public BufferedResponseWrapper12Impl(HttpServletResponse httpServletResponse) {
        this.response = httpServletResponse;
        this.outputWriter = new CharArrayWriter();
        this.servletOutputStream = new SimpleServletOutputStream();
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String theContentType) {
        if (this.state) {
            log.debug((Object)"Allowing content type");
            if (this.contentType != null && this.contentType.indexOf("charset") > -1) {
                String charset = this.contentType.substring(this.contentType.indexOf("charset"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding charset: [" + charset + "]"));
                }
                this.getResponse().setContentType(StringUtils.substringBefore((String)theContentType, (String)"charset") + ' ' + charset);
            } else {
                this.getResponse().setContentType(theContentType);
            }
        }
        this.contentType = theContentType;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.state && !this.outRequested) {
            log.debug((Object)"getWriter() returned");
            this.servletOutputStream.reset();
            this.outputWriter.reset();
            this.outRequested = true;
            return ((HttpServletResponse)this.getResponse()).getWriter();
        }
        return new PrintWriter(this.outputWriter);
    }

    public void flushBuffer() throws IOException {
        if (this.outputWriter != null) {
            this.outputWriter.flush();
            this.servletOutputStream.outputStream.reset();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.state && !this.outRequested) {
            log.debug((Object)"getOutputStream() returned");
            this.servletOutputStream.reset();
            this.outputWriter.reset();
            this.outRequested = true;
            return ((HttpServletResponse)this.getResponse()).getOutputStream();
        }
        return this.servletOutputStream;
    }

    public void addHeader(String name, String value) {
        if ("6578706f7274".equals(name)) {
            log.debug((Object)"Magic header received, real response is now accessible");
            this.state = true;
        } else if (!ArrayUtils.contains((Object[])BufferedResponseWrapper.FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).addHeader(name, value);
        }
    }

    public boolean isOutRequested() {
        return this.outRequested;
    }

    public String getContentAsString() {
        return this.outputWriter.toString() + this.servletOutputStream.toString();
    }

    public void resetBuffer() {
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public void setContentLength(int len) {
        this.response.setContentLength(len);
    }

    public void setBufferSize(int size) {
        this.response.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void reset() {
        this.response.reset();
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public String encodeURL(String url) {
        return this.response.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.response.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.response.encodeUrl(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.response.encodeRedirectUrl(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.response.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.response.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.response.sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        if (!ArrayUtils.contains((Object[])BufferedResponseWrapper.FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            this.response.setDateHeader(name, date);
        }
    }

    public void addDateHeader(String name, long date) {
        if (!ArrayUtils.contains((Object[])BufferedResponseWrapper.FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            this.response.addDateHeader(name, date);
        }
    }

    public void setHeader(String name, String value) {
        if (!ArrayUtils.contains((Object[])BufferedResponseWrapper.FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            this.response.setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (!ArrayUtils.contains((Object[])BufferedResponseWrapper.FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            this.response.setIntHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!ArrayUtils.contains((Object[])BufferedResponseWrapper.FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            this.response.addIntHeader(name, value);
        }
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        this.response.setStatus(sc, sm);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

