package android.client.send;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

import android.app.Activity;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;


public class tcpBasedSend extends Activity {	
	
	private String return_msg;
	@Override
	public void onCreate(Bundle icicle) {
	  super.onCreate(icicle);
	  setContentView(R.layout.main);

	  LocationManager locationManager;
	  locationManager = (LocationManager)getSystemService(Context.LOCATION_SERVICE);

	  Criteria criteria = new Criteria();
	  criteria.setAccuracy(Criteria.ACCURACY_FINE);
	  criteria.setAltitudeRequired(false);
	  criteria.setBearingRequired(false);
	  criteria.setCostAllowed(true);
	  criteria.setPowerRequirement(Criteria.POWER_LOW);	  
	
	  String provider = locationManager.getBestProvider(criteria, true);

	  Location location = locationManager.getLastKnownLocation(provider);
	  
	   updateWithNewLocation(location);	 
	    
	  locationManager.requestLocationUpdates(provider, 2000, 10, locationListener);	  		   
	}
	
	
  private final LocationListener locationListener = new LocationListener() {
    public void onLocationChanged(Location location) {
      updateWithNewLocation(location);
    }
     
    public void onProviderDisabled(String provider){
      updateWithNewLocation(null);
    }

    public void onProviderEnabled(String provider){}

    public void onStatusChanged(String provider, int status, Bundle extras) {}
  };
  
  /** Update UI with a new location */
  private void updateWithNewLocation(Location location) {
    TextView myLocationText = (TextView)findViewById(R.id.myLocationText);
    
    String latLongString;
     
    if (location != null) {
      double lat = location.getLatitude();
      double lng = location.getLongitude();
      latLongString = "Lat:" + lat + " Long:" + lng;
    } else {
      latLongString = "No location found"; 
    }  
    
    myLocationText.setText("Your Current Position is:\n" + latLongString);
    
    TCPclient tp = new TCPclient(latLongString);
    tp.run();
    
  }    

  private class TCPclient implements Runnable {
	  // Ŭ ü  IP Ʈ. ׸ Է ؽƮ Ʈ Ѵ.
  private static final String serverIP = "10.0.20.192"; // ex: 192.168.0.100
  private static final int serverPort = 4321; // ex: 5555
  private String msg;
  //private String return_msg;
  
  public TCPclient(String _msg){
   this.msg = _msg;
  }
  @Override
  public void run() {
   // TODO Auto-generated method stub
   try {
      // IP ּҸ  ּҸ ´.
      InetAddress serverAddr = InetAddress.getByName(serverIP);
      
      Log.d("TCP", "C: Connecting...");
      
      // ּҿ Ʈ   ü .
      Socket socket = new Socket(serverAddr, serverPort);
      
     try {
      Log.d("TCP", "C: Sending: '" + msg + "'");
      PrintWriter out = new PrintWriter( new BufferedWriter( new OutputStreamWriter(socket.getOutputStream())),true);
      // Ͽ ޽Ʈ ߰Ͽ  .
      out.println(msg);
      Log.d("TCP", "C: Sent.");
         Log.d("TCP", "C: Done.");
         
         //   ϸ޽   ۿ ´.
         BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
         return_msg = in.readLine();
         
         Log.d("TCP", "C: Server send to me this message -->" + return_msg);
        } catch(Exception e) {
          Log.e("TCP", "C: Error1", e);
      } finally {
       socket.close();
      }
      } catch (Exception e) {
        Log.e("TCP", "C: Error2", e);
      }
  }
  
  }
  
}



