#include "act.h"
#include "actcreate.h"
#include "actunknown.h"
#include "actTests.h"

#ifdef ACT_UNKNOWN_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testUnknown_addRef(void)
{
    uint32 cRef;
    IUnknown* pUnknown;
    act_createInstance(ACTCLSID_UNKNOWN, (void**)&pUnknown);

    cRef = IUnknown_addRef(pUnknown);
    ACT_TEST_ASSERT_EQUAL_INT(2, cRef);
    cRef = IUnknown_release(pUnknown);
    ACT_TEST_ASSERT_EQUAL_INT(1, cRef);
    cRef = IUnknown_release(pUnknown);
    ACT_TEST_ASSERT_EQUAL_INT(0, cRef);
}

static void testUnknown_release(void)
{
    uint32 cRef;
    IUnknown* pUnknown;
    act_createInstance(ACTCLSID_UNKNOWN, (void**)&pUnknown);

    cRef = IUnknown_release(pUnknown);
    ACT_TEST_ASSERT_EQUAL_INT(0, cRef);
}


static void testUnknown_queryInterface(void)
{
    uint32 cRef;
    ACTRESULT result;

   IUnknown* pUnknown;
   IUnknown* pUnknownNew;
    act_createInstance(ACTCLSID_UNKNOWN, (void**)&pUnknown);

    result = IUnknown_queryInterface(pUnknown, ACTCLSID_UNKNOWN, (void **) &pUnknownNew);
    ACT_TEST_ASSERT_EQUAL_INT(ACT_S_OK, result);

    cRef = IUnknown_release(pUnknownNew); 
    ACT_TEST_ASSERT_EQUAL_INT(1, cRef);

    cRef = IUnknown_release(pUnknown); 
    ACT_TEST_ASSERT_EQUAL_INT(0, cRef);
}


ITest* UnknownTest_tests(void)
{
    ITestCaller* pUnknownTest;

    ACT_TESTCALLER_NEW( pUnknownTest, "actUnknownTest", setUp, tearDown);
    
        ACT_ADD_FIXTURE(pUnknownTest, "testUnknown_addRef", testUnknown_addRef);
        ACT_ADD_FIXTURE(pUnknownTest, "testUnknown_release", testUnknown_release);
        ACT_ADD_FIXTURE(pUnknownTest, "testUnknown_queryInterface", testUnknown_queryInterface);
    
    return (ITest*)pUnknownTest;
}
#endif // ACT_UNKNOWN_TESTS
