/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "act.h"
#include "actTests.h"
#include "actMockTestCase.h"


#ifdef ACT_TESTCASE_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testName(void)
{
    ITestCase* pMockTestCase = actMockTestCase_case();
    ACT_TEST_ASSERT_EQUAL_STRING("actMockTestCase", ITest_name((ITest*)pMockTestCase));
}

static void testCountTestCases(void)
{
    ITestCase* pMockTestCase = actMockTestCase_case();
    ACT_TEST_ASSERT_EQUAL_INT(1, ITest_countTestCases((ITest*)pMockTestCase));
}

static void success_runTest(void)
{
}

static void testSuccess(void)
{
    ITestCase* pCase;
    ITestResult* pResult;

    ACT_TESTRESULT_NEW(pResult, NULL);
    ACT_TESTCASE_NEW(pCase,"success",NULL,NULL,success_runTest);
    
    ITest_run((ITest*)pCase, pResult);
    
    ACT_TEST_ASSERT_EQUAL_INT(1, ITestResult_getRunCount(pResult));
    ACT_TEST_ASSERT_EQUAL_INT(0, ITestResult_getFailureCount(pResult));

    ACT_TESTCASE_DELETE(pCase);
    ACT_TESTRESULT_DELETE(pResult);
}

static void failure_runTest(void)
{
    ACT_TEST_FAIL("");
}

static void testFailure(void)
{
    ITestCase* pCase;
    ITestResult* pResult;

    ACT_TESTRESULT_NEW(pResult, NULL);
    ACT_TESTCASE_NEW(pCase,"failure",NULL,NULL,failure_runTest);
    
    ITest_run((ITest*)pCase, pResult);
    
    ACT_TEST_ASSERT_EQUAL_INT(1, ITestResult_getRunCount(pResult));
    ACT_TEST_ASSERT_EQUAL_INT(1, ITestResult_getFailureCount(pResult));

    ACT_TESTCASE_DELETE(pCase);
    ACT_TESTRESULT_DELETE(pResult);
}

ITest* TestCaseTest_tests(void)
{
    ITestCaller * pTestCaseTest;
    
    ACT_TESTCALLER_NEW( pTestCaseTest,"TestCaseTest",setUp,tearDown);
        ACT_ADD_FIXTURE(pTestCaseTest,"testName",testName);
        ACT_ADD_FIXTURE(pTestCaseTest,"testCountTestCases",testCountTestCases);
        ACT_ADD_FIXTURE(pTestCaseTest,"testSuccess",testSuccess);
        ACT_ADD_FIXTURE(pTestCaseTest,"testFailure",testFailure);
    
    return (ITest* )pTestCaseTest;
}

#endif // def ACT_TESTCASE_TESTS
