/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "act.h"
#include "actTests.h"

#ifdef ACT_TESTCALLER_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testOneFixture(void)
{
    ITestCaller* pCaller;
    ITestResult* pResult;
    
    ACT_TESTRESULT_NEW(pResult, NULL);
    ACT_TESTCALLER_NEW( pCaller,"", NULL, NULL);
        ACT_ADD_FIXTURE(pCaller,"",NULL);
    
    ITest_run ((ITest*)pCaller,pResult);
    
    ACT_TEST_ASSERT_EQUAL_INT(1, ITestResult_getRunCount(pResult));
    ACT_TEST_ASSERT_EQUAL_INT(1, ITest_countTestCases((ITest*)pCaller));

    ACT_TESTCALLER_DELETE(pCaller);
    ACT_TESTRESULT_DELETE(pResult);
}

static void testMoreThanOne(void)
{
    ITestCaller* pCaller;
    ITestResult* pResult;

    ACT_TESTRESULT_NEW(pResult, NULL);

    ACT_TESTCALLER_NEW( pCaller, "", NULL, NULL);    
        ACT_ADD_FIXTURE(pCaller, "", NULL);
        ACT_ADD_FIXTURE(pCaller, "", NULL);
        ACT_ADD_FIXTURE(pCaller, "", NULL);
        ACT_ADD_FIXTURE(pCaller, "", NULL);
        ACT_ADD_FIXTURE(pCaller, "", NULL);

    ITest_run((ITest*)pCaller, pResult);
    
    ACT_TEST_ASSERT_EQUAL_INT(5, ITestResult_getRunCount(pResult));
    ACT_TEST_ASSERT_EQUAL_INT(5, ITest_countTestCases((ITest*)pCaller));

    ACT_TESTCALLER_DELETE(pCaller);
    ACT_TESTRESULT_DELETE(pResult);

}

static void testZeroFixture(void)
{
    ITestCaller* pCaller;
    ITestResult* pResult;
    
    ACT_TESTCALLER_NEW(pCaller,"", NULL, NULL);
    ACT_TESTRESULT_NEW(pResult, NULL);
    

    ITest_run((ITest*)pCaller, pResult);
    
    ACT_TEST_ASSERT_EQUAL_INT(0, ITestResult_getRunCount(pResult));
    ACT_TEST_ASSERT_EQUAL_INT(0, ITest_countTestCases((ITest*)pCaller));

    ACT_TESTCALLER_DELETE(pCaller);
    ACT_TESTRESULT_DELETE(pResult);
}

ITest* TestCallerTest_tests(void)
{
    ITestCaller* pTestCallerTest;
	
    ACT_TESTCALLER_NEW( pTestCallerTest, "TestCallerTest", setUp, tearDown);
        ACT_ADD_FIXTURE(pTestCallerTest, "testOneFixture", testOneFixture);
        ACT_ADD_FIXTURE(pTestCallerTest, "testMoreThanOne", testMoreThanOne);
        ACT_ADD_FIXTURE(pTestCallerTest, "testZeroFixture", testZeroFixture);
    
    return (ITest*)pTestCallerTest;
}

#endif // def ACT_TESTCALLER_TESTS
