/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTLISTENERMFC_H__
#define __ACTTESTLISTENERMFC_H__

#include "acttestlistener.h"
#include "TestRunnerDlg.h"


class TestRunnerDlg;

typedef struct __ITestListenerMfc	ITestListenerMfc;

typedef struct __ITestListenerMfcVtbl	ITestListenerMfcVtbl;

struct __ITestListenerMfcVtbl {
    uint32 (* addRef) (ITestListenerMfc* pobj);
    uint32 (* release) (ITestListenerMfc* pobj);
    ACTRESULT (*queryInterface)(ITestListenerMfc* pobj, ACTCLSID clsid, void ** ppNew);
   
	TestListenerStartTestCallBack startTest;
	TestListenerEndTestCallBack endTest;
	TestListenerAddFailureCallBack addFailure;

    ACTRESULT (*init)(ITestListenerMfc* pobj, TestRunnerDlg *pDlg);
};


#define ITestListenerMfc_addRef(pobj)         (*(ITestListenerMfcVtbl**)pobj)->addRef(pobj)
#define ITestListenerMfc_release(pobj)         (*(ITestListenerMfcVtbl**)pobj)->release(pobj)
#define ITestListenerMfc_queryInterface(pobj,id,ppn) (*(ITestListenerMfcVtbl**)pobj)->queryInterface(pobj,id,ppn)

#define ITestListenerMfc_startTest(po,test)				(*(ITestListenerMfcVtbl**)po)->startTest(po,test)
#define ITestListenerMfc_endTest(po,test)					(*(ITestListenerMfcVtbl**)po)->endTest(po,test)
#define ITestListenerMfc_addFailure(po,test,msg,line,file)	(*(ITestListenerMfcVtbl**)po)->addFailure(po,test,msg,line,file)

#define ITestListenerMfc_init(po,test)					(*(ITestListenerMfcVtbl**)po)->init(po,test)

#endif /* __ACTTESTLISTENERMFC_H__ */
