/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "stdafx.h"
#include "resource.h"
#include "TestRunnerDlg.h"

//#include "	\ add additional includes here"

#include "act.h"
#include "actTestList.h"
#include "acttestvector.h"
#include "acttestvector_protected.h"

#include "acttestrunnermfc.h"
#include "acttestrunnermfc_protected.h"
#include "acttestrunnermfc_private.h"


#include "TestRunnerModel.h"


/////////////////////////////////////////////////////////////////////////////
//
// ITestRunnerMfc Implementation
//

ACTRESULT 
_ITestRunnerMfc_new(ITestRunnerMfc** ppobj)
{
    ACTRESULT result;
    ITestRunnerMfc *pme;

    pme = (ITestRunnerMfc*) act_malloc(sizeof(ITestRunnerMfc)+sizeof(ITestRunnerMfcVtbl));

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }

    _ITestRunnerMfc_ctor(pme, (ITestRunnerMfcVtbl*)(pme+1));    
    result = _ITestRunnerMfc_init(pme);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestRunnerMfc_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestRunnerMfc*)pme;
    
    return result;
    
}

void 
_ITestRunnerMfc_ctor(ITestRunnerMfc* pme, ITestRunnerMfcVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestRunnerMfc_initVtbl(pvt);
    }    
}


void 
_ITestRunnerMfc_initVtbl(ITestRunnerMfcVtbl* pvt)
{
    pvt->addRef = _ITestRunnerMfc_addRef;
    pvt->release = _ITestRunnerMfc_release;
    pvt->queryInterface = _ITestRunnerMfc_queryInterface;

    pvt->start = __ITestRunnerMfc_start;
    pvt->addTest = __ITestRunnerMfc_addTest;
    pvt->runTest = __ITestRunnerMfc_runTest;
    pvt->end = __ITestRunnerMfc_end;
    pvt->getRootTest = __ITestRunnerMfc_getRootTest;
}

ACTRESULT 
_ITestRunnerMfc_init(ITestRunnerMfc* pobj)
{
    ITestRunnerMfc * pme;
    pme = (ITestRunnerMfc *) pobj;

    ACT_TESTSUITE_NEW(pme->m_suite_, "All tests");

    act_createInstance(ACTCLSID_TESTVECTOR, (void**) &pme->m_tests);
    
    ITestVec_init(pme->m_tests, 8);

    return ACT_S_OK;
}


uint32 
_ITestRunnerMfc_addRef(ITestRunnerMfc* pobj)
{
    ITestRunnerMfc* pme = (ITestRunnerMfc*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestRunnerMfc_release(ITestRunnerMfc* pobj)
{
    ITestRunnerMfc* pme;
    uint32 cRef;

    pme = (ITestRunnerMfc*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestRunnerMfc_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestRunnerMfc_xtor(ITestRunnerMfc* pme)
{
    ITest* pTest;
    ITestVecIterator* pIterator;

    if(pme)
    {
        ITest_release((ITest*) pme->m_suite_);

        act_createInstance(ACTCLSID_TESTVECTORITERATOR, (void**) &pIterator);
        _ITestVecIterator_init(pIterator, pme->m_tests);
        for(ITestVecIterator_First(pIterator);!ITestVecIterator_IsDone(pIterator);ITestVecIterator_Next(pIterator))
        {
            pTest = ITestVecIterator_CurrentItem(pIterator);
            ITest_release(pTest);
        }
        ITestVecIterator_release(pIterator);
    }
}


ACTRESULT 
_ITestRunnerMfc_queryInterface(ITestRunnerMfc* pobj, ACTCLSID clsid, void ** ppNew)
{
    ACTRESULT result;

    result = ACT_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == ACTCLSID_UNKNOWN ||
        clsid == ACTCLSID_TESTRUNNERMFC)
    {
        *ppNew = pobj;
        _ITestRunnerMfc_addRef(pobj);
        result = ACT_S_OK;
    }
    
    return result;
}


static void __ITestRunnerMfc_start(ITestRunnerMfc* pme)
{

}


static void __ITestRunnerMfc_addTest(ITestRunnerMfc* pme, ITest* test)
{
    ITestVec_push_back(pme->m_tests, test);
}


static void __ITestRunnerMfc_runTest(ITestRunnerMfc* pMe)
{
     bool comInit = SUCCEEDED( CoInitialize( NULL) );

     TestRunnerModel model( ITestRunnerMfc_getRootTest(pMe));

     TestRunnerDlg dlg(&model);

     dlg.DoModal();

     if(comInit)
         CoUninitialize();
}


static void __ITestRunnerMfc_end(ITestRunnerMfc* pme)
{
}


static ITest*   __ITestRunnerMfc_getRootTest(ITestRunnerMfc* pme)
{
    if(ITestVec_size(pme->m_tests) != 1)
    {        
        ITestVecIterator* pIt;
        ITest* pTest;
        
        act_createInstance(ACTCLSID_TESTVECTORITERATOR, (void**) &pIt);
        _ITestVecIterator_init(pIt, pme->m_tests);
        for(ITestVecIterator_First(pIt); !ITestVecIterator_IsDone(pIt); ITestVecIterator_Next(pIt))
        {
            pTest = ITestVecIterator_CurrentItem(pIt);
            ITestSuite_addTest(pme->m_suite_, pTest);
        }
        ITestVecIterator_release(pIt);

        ITestVec_clear(pme->m_tests);

        return (ITest*)pme->m_suite_;
    }
    return ITestVec_get(pme->m_tests, 0);
}
