/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "stdafx.h"

#include "ResourceLoaders.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



extern HINSTANCE g_testRunnerResource;

CString loadCString(UINT stringId)
{
  CString string;
  
  HRSRC stringRes = ::FindResource( g_testRunnerResource, 
                                   MAKEINTRESOURCE( (stringId>>4) + 1),
                                   RT_STRING );
  if ( stringRes )
  {
    int stringLen = ::SizeofResource( g_testRunnerResource, 
                                      stringRes) / sizeof(TCHAR);
    if (stringLen > 0)
    {
      LPTSTR stringBuffer = string.GetBuffer( stringLen+2 );
      int realStringLen = ::LoadString( g_testRunnerResource, 
                                        stringId, 
                                        stringBuffer, 
                                        (stringLen+1)*2 );
      string.ReleaseBuffer( realStringLen );

      ASSERT(realStringLen > 0);
    }
  }

  ASSERT( !string.IsEmpty() );
  return string;
}

