/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "StdAfx.h"
#include "ListCtrlFormatter.h"
#include <string>


ListCtrlFormatter::ListCtrlFormatter( CListCtrl &list ) :
    m_List( list ),
    m_nColNo( 0 )
{
}


ListCtrlFormatter::~ListCtrlFormatter()
{
}


void 
ListCtrlFormatter::AddColumn( CString strHeading,
                              int nWidth,
                              int nFormat,
                              int nSubItemNo )
{
  LVCOLUMN column;
  column.mask = LVCF_FMT | LVCF_SUBITEM  | LVCF_TEXT | LVCF_WIDTH;
  column.cx = nWidth;
  column.fmt = nFormat;
  column.pszText = strHeading.GetBuffer( strHeading.GetLength() );
  column.iSubItem = nSubItemNo == -1 ? m_nColNo : nSubItemNo;
  column.iImage = 0;
  column.iOrder = 0;
  VERIFY( m_List.InsertColumn( m_nColNo++, &column ) >= 0 );
  strHeading.ReleaseBuffer();
/*
  VERIFY( m_List.InsertColumn( m_nColNo++, 
                               strHeading, 
                               nFormat,
                               nWidth, 
                               nSubItemNo ) >= 0 );
*/
  }


void 
ListCtrlFormatter::AddColumn( const std::string &strHeading,
                              int nWidth,
                              int nFormat,
                              int nSubItemNo )
{
  AddColumn( CString( strHeading.c_str() ), nWidth, nFormat, nSubItemNo );
}


void 
ListCtrlFormatter::AddColumn( UINT nIdStringHeading,
                              int nWidth,
                              int nFormat,
                              int nSubItemNo )
{
  CString strHeading;
  VERIFY( strHeading.LoadString( nIdStringHeading ) );
  AddColumn( strHeading, nWidth, nFormat, nSubItemNo );
}


int
ListCtrlFormatter::GetNextColumnIndex() const
{
  return m_nColNo;
}
