/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

// ActiveTest.cpp: implementation of the ActiveTest class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "act.h"
#include "acttestrunnermfc.h"
#include "ActiveTest.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

// Construct the active test
ActiveTest::ActiveTest(ITest* test)
   : m_test(test)
{
  m_currentTestResult = NULL; 
  m_threadHandle = INVALID_HANDLE_VALUE; 
}


// Pend until the test has completed
ActiveTest::~ActiveTest()
{
  CSingleLock( &m_runCompleted, TRUE );
  m_test = NULL;
}


// Set the test result that we are to run
void 
ActiveTest::setTestResult( ITestResult *result )
{ 
  m_currentTestResult = result; 
}


// Run our test result
void 
ActiveTest::run()
{ 
  //TestDecorator::run( m_currentTestResult );
    ITest_run(m_test, m_currentTestResult);
}


// Spawn a thread to a test
void 
ActiveTest::run( ITestResult *result )
{
  CWinThread *thread;
  
  setTestResult( result );
  m_runCompleted.ResetEvent();

  thread = ::AfxBeginThread( threadFunction, 
                             this, 
                             THREAD_PRIORITY_NORMAL, 
                             0, 
                             CREATE_SUSPENDED);
  
  ::DuplicateHandle( GetCurrentProcess(), 
                     thread->m_hThread,
                     GetCurrentProcess(), 
                     &m_threadHandle, 
                     0, 
                     FALSE, 
                     DUPLICATE_SAME_ACCESS );

  thread->ResumeThread ();
}


// Simple execution thread.  Assuming that an ActiveTest instance
// only creates one of these at a time.
UINT 
ActiveTest::threadFunction( LPVOID thisInstance )
{
  ActiveTest *test = (ActiveTest *)thisInstance;
  

  //test->run ();
  ITest_run(test->m_test,test->m_currentTestResult);


  ::CloseHandle( test->m_threadHandle );
  test->m_threadHandle = INVALID_HANDLE_VALUE;

  test->m_runCompleted.SetEvent();

  return 0;
}

