/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/


#include "actcommon.h"
#include "acttest.h"
#include "acttestvector.h"
#include "acttestvector_protected.h"
#include "acttestvector_private.h"



ACTRESULT 
_ITestVec_new(ITestVec** ppobj)
{
    ACTRESULT result;
    ITestVec* pme;

    pme = (ITestVec*) act_malloc(sizeof(ITestVec) + sizeof(ITestVecVtbl));

    *ppobj = NULL;

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }
    
    _ITestVec_ctor(pme, (ITestVecVtbl*)(pme+1));
    result = _ITestVec_init(pme, 0);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestVec_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestVec*)pme;
    
    return result;
}


void 
_ITestVec_ctor(ITestVec* pobj, ITestVecVtbl* pvt)
{
    pobj->m_cRef = 1;

    if(pvt)
    {
        pobj->pvt = pvt;
        _ITestVec_initVtbl(pvt);
    }    
}


void 
_ITestVec_initVtbl(ITestVecVtbl* pvt)
{
    pvt->addRef = _ITestVec_addRef;
    pvt->release = _ITestVec_release;
    pvt->queryInterface = _ITestVec_queryInterface;
    pvt->init =_ITestVec_init;
    pvt->push_back = __ITestVec_push_back;
    pvt->insert_before =  __ITestVec_insert_before;
    pvt->erase = __ITestVec_erase;
    pvt->size= __ITestVec_size;
    pvt->capacity= __ITestVec_capacity;
    pvt->get= __ITestVec_get;
    pvt->clear= __ITestVec_clear;
    pvt->find= __ITestVec_find;
}


ACTRESULT 
_ITestVec_init(ITestVec* pobj,int initial_capacity)
{
    ITestVec * pMe = (ITestVec*) pobj;
     pMe->size = 0;
        pMe->capa = 0;
        pMe->body = (ITest**)act_malloc(sizeof(ITest*)*initial_capacity);
        if ( pMe->body ) 
        {
            pMe->capa = initial_capacity;
        }
      return ACT_S_OK;
}


uint32 
_ITestVec_addRef(ITestVec* pobj)
{
    ITestVec* pme = (ITestVec*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestVec_release(ITestVec* pobj)
{
    ITestVec* pme;
    uint32 cRef;

    pme = (ITestVec*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestVec_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestVec_xtor(ITestVec* pobj)
{
    
}


ACTRESULT 
_ITestVec_queryInterface(ITestVec* pobj, ACTCLSID clsid, void ** ppNew)
{
    if(clsid == ACTCLSID_TESTVECTOR)
    {
        *ppNew = pobj;
        _ITestVec_addRef(pobj);
        return ACT_S_OK;
    }
    *ppNew = 0;
    
    return ACT_E_CLASSNOTSUPPORT;
}


static void
__ITestVec_clear(ITestVec* pMe) 
{
    int i;
    for ( i = 0; i < pMe->size; ++i ) 
    {
        ITest_release(pMe->body[i]);
    }
    pMe->size = 0;
}


static void
__ITestVec_grow(ITestVec* pMe) 
{
    if ( pMe->size >= pMe->capa ) 
    {
        int new_capa = pMe->capa + 8;
        ITest** new_body = (ITest**)malloc(sizeof(ITest*) * new_capa);
        if ( new_body ) 
        {
            int i;
            for ( i = 0; i < pMe->size; ++i ) 
            {
                new_body[i] = pMe->body[i];
            }
            act_free(pMe->body);
            pMe->body = new_body;
            pMe->capa = new_capa;
        }
    }
}

static void
__ITestVec_push_back(ITestVec* pMe, ITest* str)
{
    __ITestVec_grow(pMe);
    pMe->body[pMe->size++] = str; //strdup(str);
}

static void
__ITestVec_insert_before(ITestVec* pMe, int pos, ITest* str) {
    int i;
    if ( pos < 0 ) return;
    if ( pos >= pMe->size ) return;
    __ITestVec_grow(pMe);
    for ( i = pMe->size; i > pos; --i ) 
    {
        pMe->body[i] = pMe->body[i-1];
    }
    pMe->body[pos] = str; // strdup(str);
    ++pMe->size;
}

static int
__ITestVec_size(ITestVec* pMe) 
{
    return pMe->size;
}

static void
__ITestVec_erase(ITestVec* pMe, int pos) 
{
    int i;
    
    if ( pos < 0 ) return;
    if ( pos >= pMe->size ) return;
    
    ITest_release(pMe->body[pos]);

    for ( i = pos; i < pMe->size - 1; ++i ) 
    {
        pMe->body[i] = pMe->body[i+1];
    }
    --pMe->size;
}

static int
__ITestVec_capacity(ITestVec* pMe) 
{
    return pMe->capa;
}

static ITest* 
__ITestVec_get(ITestVec* pMe, int index) 
{
    if ( index >= 0 || index < pMe->size ) 
    {
        return pMe->body[index];
    }
    return 0;
}

static int
__ITestVec_find(ITestVec* pMe,  ITest* pTest) 
{
    int i;
    for ( i = 0; i < pMe->size; ++i ) 
    {
        if ( strcmp((const char*)ITest_name(pTest), (const char*)ITest_name(pMe->body[i])) == 0 ) 
            return i;
    }
    return -1;
}



ACTRESULT 
_ITestVecIterator_new(ITestVecIterator** ppobj)
{
    ACTRESULT result;
    ITestVecIterator* pme;

    pme = (ITestVecIterator*) act_malloc(sizeof(ITestVecIterator) + sizeof(ITestVecIteratorVtbl));

    *ppobj = NULL;

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }
    
    _ITestVecIterator_ctor(pme, (ITestVecIteratorVtbl*)(pme+1));
    result = _ITestVecIterator_init(pme, 0);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestVecIterator_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestVecIterator*)pme;
    
    return result;
}


void 
_ITestVecIterator_ctor(ITestVecIterator* pobj, ITestVecIteratorVtbl* pvt)
{
    pobj->m_cRef = 1;

    if(pvt)
    {
        pobj->pvt = pvt;
        _ITestVecIterator_initVtbl(pvt);
    }    
}


void 
_ITestVecIterator_initVtbl(ITestVecIteratorVtbl* pvt)
{
    pvt->addRef = _ITestVecIterator_addRef;
    pvt->release = _ITestVecIterator_release;
    pvt->queryInterface = _ITestVecIterator_queryInterface;

    pvt->init = _ITestVecIterator_init;
    pvt->First = __ITestVecIterator_First;
    pvt->Next = __ITestVecIterator_Next;
    pvt->IsDone = __ITestVecIterator_IsDone;
    pvt->CurrentItem = __ITestVecIterator_CurrentItem;
}


ACTRESULT 
_ITestVecIterator_init(ITestVecIterator* pobj,ITestVec* pTestVec)
{
    ITestVecIterator* pme = (ITestVecIterator*) pobj;    
    
        pme->m_pTestVec_ = pTestVec;
    pme->m_nCurrent_ = 0;   
      return ACT_S_OK;
}


uint32 
_ITestVecIterator_addRef(ITestVecIterator* pobj)
{
    ITestVecIterator* pme = (ITestVecIterator*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestVecIterator_release(ITestVecIterator* pobj)
{
    ITestVecIterator* pme;
    uint32 cRef;

    pme = (ITestVecIterator*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestVecIterator_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestVecIterator_xtor(ITestVecIterator* pobj)
{
    
}


ACTRESULT 
_ITestVecIterator_queryInterface(ITestVecIterator* pobj, ACTCLSID clsid, void ** ppNew)
{
    if(clsid == ACTCLSID_TESTVECTORITERATOR)
    {
        *ppNew = pobj;
        _ITestVecIterator_addRef(pobj);
        return ACT_S_OK;
    }
    *ppNew = 0;
    
    return ACT_E_CLASSNOTSUPPORT;
}


static void    __ITestVecIterator_First(ITestVecIterator* pme)
{
    pme->m_nCurrent_ = 0;
}

static void    __ITestVecIterator_Next(ITestVecIterator* pme)
{
    pme->m_nCurrent_++;
}

static boolean __ITestVecIterator_IsDone(ITestVecIterator* pme)
{
    return pme->m_nCurrent_ >= ITestVec_size(pme->m_pTestVec_);
}


static ITest* __ITestVecIterator_CurrentItem(ITestVecIterator* pme)
{
    return ITestVec_get(pme->m_pTestVec_, pme->m_nCurrent_);
}
