/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/


#include "actcommon.h"
#include "acttest.h"
#include "acttestcase.h"

#include "acttestfixture.h"
#include "acttestfixturelist.h"
#include "acttestcaller_private.h"


// 
// ITestCaller Implementation
//

ACTRESULT 
_ITestCaller_new(ITestCaller** ppobj)
{
    ACTRESULT result;
    ITestCaller * pme;

    pme = (ITestCaller*) act_malloc(sizeof(ITestCaller) + sizeof(ITestCallerVtbl) );

    *ppobj = NULL;

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }
    
    _ITestCaller_ctor(pme, (ITestCallerVtbl*)(pme+1));
    result = _ITestCaller_init(pme,"", NULL, NULL);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestCaller_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestCaller*)pme;
    
    return result;
    
}

void 
_ITestCaller_ctor(ITestCaller* pme, ITestCallerVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestCaller_initVtbl(pvt);
    }    
}


void 
_ITestCaller_initVtbl(ITestCallerVtbl* pvt)
{
    pvt->addRef = _ITestCaller_addRef;
    pvt->release = _ITestCaller_release;
    pvt->queryInterface = _ITestCaller_queryInterface;
    pvt->name = _ITestCaller_name;
    pvt->run = _ITestCaller_run;
    pvt->countTestCases = _ITestCaller_countTestCases;
    pvt->getChildTestCount = _ITestCaller_getChildTestCount;
    pvt->getChildTestAt = _ITestCaller_getChildTestAt;
    pvt->findTest = _ITestCaller_findTest;

    pvt->init = _ITestCaller_init;
    pvt->addTestFixture = _ITestCaller_addTestFixture;

}

ACTRESULT 
_ITestCaller_init(ITestCaller* pobj, char * name, PFNSETUP setup, PFNTEARDWON tdw)
{
    ACTRESULT result;
    ITestCaller * pme;
    pme = (ITestCaller *) pobj;

    act_strncpy(pme->name, name, ACT_TEST_NAME_LENGTH);
    
    pme->setUp = setup;
    pme->tearDown = tdw;

    result = act_createInstance(ACTCLSID_TESTFIXTURELIST, (void**) &pme->m_lstFixture);

    return result;
}


uint32 
_ITestCaller_addRef(ITestCaller* pobj)
{
    ITestCaller* pme = (ITestCaller*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestCaller_release(ITestCaller* pobj)
{
    ITestCaller* pme;
    uint32 cRef;

    pme = (ITestCaller*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestCaller_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestCaller_xtor(ITestCaller* pme)
{
    ITestFixtureList_release(pme->m_lstFixture);
}


ACTRESULT 
_ITestCaller_queryInterface(ITestCaller* pobj, ACTCLSID clsid, void ** ppNew)
{
    ACTRESULT result;

    result = ACT_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == ACTCLSID_UNKNOWN ||
        clsid == ACTCLSID_TEST ||
        clsid == ACTCLSID_TESTCALLER)
    {
        *ppNew = pobj;
        _ITestCaller_addRef(pobj);
        result = ACT_S_OK;
    }
    
    return result;
}


char* _ITestCaller_name(ITestCaller* pme)
{
	return pme->name;
}

void _ITestCaller_run(ITestCaller* pme,ITestResult* result)
{
	ITestCase* piTestCase = NULL;
    ITest*      piTest = NULL;
    ITestFixture* piTestFixture = NULL;
    ITestFixtureNode * pITestFixtureNode = NULL;
    int numberOfFixtures;
	int i;


    act_createInstance(ACTCLSID_TESTCASE, (void**)&piTestCase);
    


    ITestCase_init(piTestCase, "", pme->setUp, pme->tearDown, NULL);

    ITestCase_queryInterface(piTestCase, ACTIID_TEST,(void**)&piTest);
    numberOfFixtures = ITestFixtureList_getCount(pme->m_lstFixture);
    pITestFixtureNode = (ITestFixtureNode *)ITestFixtureList_getHeadPosition(pme->m_lstFixture);
    
    for(i = 0; i < numberOfFixtures; i++)
    {
        piTestFixture = (ITestFixture *)ITestFixtureList_getNext(pme->m_lstFixture, &pITestFixtureNode);

        ITestCase_setName(piTestCase, ITestFixture_name(piTestFixture));
        ITestCase_setRunTest(piTestCase, ITestFixture_test(piTestFixture));
        
        ITest_run(piTest, result);
    }
    ITest_release(piTest);
    ITestCase_release(piTestCase);
}

int _ITestCaller_countTestCases(ITestCaller* pme)
{
//	return //pme->numberOfFixtuers;
    return ITestFixtureList_getCount(pme->m_lstFixture);
}

int _ITestCaller_getChildTestCount(ITestCaller* pme)
{
//	return //pme->numberOfFixtuers;
    return ITestFixtureList_getCount(pme->m_lstFixture);
}


ITest*      _ITestCaller_getChildTestAt(ITestCaller* pme, int index)
{
    ITestCase *piTestCase;
    ITestFixture *piTestFixture;
    ITestFixtureNode * pNode;

    
    pNode = (ITestFixtureNode *)ITestFixtureList_findIndex(pme->m_lstFixture, index);
    piTestFixture = (ITestFixture *)ITestFixtureList_getAt(pme->m_lstFixture, pNode);

    act_createInstance(ACTCLSID_TESTCASE, (void**)&piTestCase);
    ITestCase_init(piTestCase, ITestFixture_name(piTestFixture),pme->setUp,pme->tearDown,ITestFixture_test(piTestFixture));

    return (ITest *)piTestCase;
}


ITest*     _ITestCaller_findTest(ITestCaller* pme, char *pszName)
{
    ITestCase *piTestCase;
    ITestFixture* piTestFixture;
    ITestFixtureNode * piTestFixtureNode;

    char* pszTestName;
    int numberOfFixtures;
    int i;

    pszTestName = ITestCaller_name(pme);
    if(act_strcmp(pszTestName, pszName) == 0)
    {
        return (ITest*) pme;
    }

    numberOfFixtures = ITestFixtureList_getCount(pme->m_lstFixture);
    piTestFixtureNode = (ITestFixtureNode *)ITestFixtureList_getHeadPosition(pme->m_lstFixture);
        
    for(i = 0; i < numberOfFixtures; i++)
    {
        piTestFixture = (ITestFixture *)ITestFixtureList_getNext(pme->m_lstFixture, &piTestFixtureNode);
       pszTestName =  ITestFixture_name(piTestFixture);
        if(act_strcmp(pszTestName, pszName) == 0)
        {
            act_createInstance(ACTCLSID_TESTCASE, (void**)&piTestCase);
            ITestCase_init(piTestCase, ITestFixture_name(piTestFixture),pme->setUp,pme->tearDown,ITestFixture_test(piTestFixture));

            return (ITest*) piTestCase;
        }
    }
    return NULL;    
}

void _ITestCaller_addTestFixture(ITestCaller* pme, ITestFixture* pFixture)
{
    ITestFixtureList_addTail(pme->m_lstFixture, pFixture);
}

