/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTLIST_PRIVATE_H__
#define __ACTTESTLIST_PRIVATE_H__

#include "acttestlist_protected.h"

#ifdef	__cplusplus
extern "C" {
#endif

static const ITest* List_getHead(ITestList *pMe);
static const ITest* List_getTail(ITestList *pMe);
static ITest* List_removeHead(ITestList *pMe, boolean bDataDelete) ;
static ITest* List_removeTail(ITestList *pMe, boolean bDataDelete);
static ITestNode* List_addHead(ITestList *pMe, ITest* pData);
static ITestNode* List_addTail(ITestList *pMe, ITest* pData);
static void List_removeAll(ITestList *pMe, boolean bDataDelete);
static const ITestNode* List_getHeadPosition(ITestList *pMe);
static const ITestNode* List_getTailPosition(ITestList *pMe);
static const ITest* List_getNext(ITestList *pMe, ITestNode** ppPosition);
static const ITest* List_getPrev(ITestList *pMe, ITestNode** ppPosition);
static const ITest* List_getAt(ITestList *pMe, ITestNode* position);
static void List_setAt(ITestList *pMe, ITestNode* pos, ITest* newElement, boolean bDeleteData);
static void List_removeAt(ITestList *pMe, ITestNode* position, boolean bDeleteData);
static ITestNode* List_insertBefore(ITestList *pMe, ITestNode* pos, ITest* newElement);
static ITestNode* List_insertAfter(ITestList *pMe, ITestNode* pos, ITest*newElement);
static const ITestNode* List_find(ITestList *pMe, ITest* searchValue, ITestNode* startAfter);
static const ITestNode* List_findIndex(ITestList *pMe, int nIndex);
static const int List_getNo(ITestList *pMe, ITest* searchValue, ITestNode* startAfter);
static int List_getCount(ITestList *pMe);
static boolean List_isEmpty(ITestList *pMe);

#ifdef	__cplusplus
}
#endif

#endif /* __ACTTESTLIST_PRIVATE_H__ */

