/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__ACTTESTRUNNER_H__
#define	__ACTTESTRUNNER_H__

#include "acttest.h"

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct __ITestRunner        ITestRunner;

typedef struct __ITestRunnerVtbl    ITestRunnerVtbl;

struct __ITestRunnerVtbl 
{
    uint32 (*addRef)(ITestRunner* po);
    uint32 (*release)(ITestRunner* po);
    ACTRESULT (*queryInterface)(ITestRunner* pobj, ACTCLSID clsid, void ** ppNew);
    
    void (*start)(ITestRunner* po);
    void (*addTest)(ITestRunner* po, ITest* test);
    void (*runTest)(ITestRunner* po);
	void (*end)(ITestRunner*po);
};

#define ITestRunner_addRef(pobj)         (*(ITestRunnerVtbl**)pobj)->addRef(pobj)
#define ITestRunner_release(pobj)         (*(ITestRunnerVtbl**)pobj)->release(pobj)
#define ITestRunner_queryInterface(po,id,ppn) (*((ITestRunnerVtbl**)po))->queryInterface(po,id,ppn)

#define ITestRunner_start(po)           (*(ITestRunnerVtbl**)po)->start(po)
#define ITestRunner_addTest(po,test)    (*(ITestRunnerVtbl**)po)->addTest(po,test)
#define ITestRunner_runTest(po)         (*(ITestRunnerVtbl**)po)->runTest(po)
#define ITestRunner_end(po)             (*(ITestRunnerVtbl**)po)->end(po)

#ifdef	__cplusplus
}
#endif

#endif/*__ACTTESTRUNNER_H__*/

