/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTRESULT_H__
#define __ACTTESTRESULT_H__
/**
@file acttestresult.h
*/
#include "acttest.h"
#include "acttestlistener.h"

#ifdef	__cplusplus
extern "C" {
#endif


/*typedef struct __ITestResult		ITestResult;*//* -> actTest.h*/

typedef struct __ITestResultVtbl ITestResultVtbl;

struct __ITestResultVtbl 
{
    uint32 (*addRef)(ITestResult* pme);
    uint32 (* release) (ITestResult* pobj);
    ACTRESULT (*queryInterface)(ITestResult* pobj, ACTCLSID clsid, void ** ppNew);
    
	ACTRESULT (*init)(ITestResult* pme,ITestListener* listner);
	void (*startTest)(ITestResult* pme,ITest* test);
	void (*endTest)(ITestResult* pme,ITest* test);
	void (*addFailure)(ITestResult* pme,ITest* test,const char* msg,int line,const char* file);

       int (*getFailureCount)(ITestResult* pme);
       int (*getRunCount)(ITestResult* pme);
};

#define ITestResult_addRef(po)              (*(ITestResultVtbl**)po)->addRef(po)
#define ITestResult_release(po)              (*(ITestResultVtbl**)po)->release(po)
#define ITestResult_queryInterface(pobj,id,ppn) (*(ITestResultVtbl**)pobj)->queryInterface(pobj,id,ppn)

#define ITestResult_init(po,listener)       (*(ITestResultVtbl**)po)->init(po,listener)
#define ITestResult_startTest(po,test)      (*(ITestResultVtbl**)po)->startTest(po,test)
#define ITestResult_endTest(po,test)        (*(ITestResultVtbl**)po)->endTest(po,test)
#define ITestResult_addFailure(po,t,m,l,f)  (*(ITestResultVtbl**)po)->addFailure(po,t,m,l,f)

#define ITestResult_getFailureCount(pobj) (*(ITestResultVtbl**)pobj)->getFailureCount(pobj)
#define ITestResult_getRunCount(pobj) (*(ITestResultVtbl**)pobj)->getRunCount(pobj)

#ifdef	__cplusplus
}
#endif

#endif /* __ACTTESTRESULT_H__ */
