/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__ACTTESTCALLER_H__
#define	__ACTTESTCALLER_H__

#include "acttestresult.h"
#include "acttestfixture.h"

typedef struct __ITestCaller		ITestCaller;

typedef struct __ITestCallerVtbl	ITestCallerVtbl;

struct __ITestCallerVtbl 
{
    uint32 (* addRef) (ITestCaller* pobj);
    uint32 (* release) (ITestCaller* pobj);
    ACTRESULT (*queryInterface)(ITestCaller* pobj, ACTCLSID clsid, void ** ppNew);
    char* (*name)(ITestCaller* pobj);
    void (*run)(ITestCaller* pobj, ITestResult* pResult);
    int  (*countTestCases)(ITestCaller* pobj);
    int  (*getChildTestCount)(ITestCaller* pobj);
    ITest* (*getChildTestAt)(ITestCaller* pobj, int index);
    ITest* (*findTest)(ITestCaller* pobj, char *name);

    ACTRESULT (*init)(ITestCaller* pobj, char * name, PFNSETUP setup, PFNTEARDWON tdw);
    void (*addTestFixture)(ITestCaller* pme, ITestFixture* fixture);
};

#define ITestCaller_addRef(pobj)         (*(ITestCallerVtbl**)pobj)->addRef(pobj)
#define ITestCaller_release(pobj)         (*(ITestCallerVtbl**)pobj)->release(pobj)
#define ITestCaller_queryInterface(po,id,ppn) (*((ITestCallerVtbl**)po))->queryInterface(po,id,ppn)
#define ITestCaller_name(pobj)           (*(ITestCallerVtbl**)pobj)->name(pobj)
#define ITestCaller_run(pobj,r)          (*(ITestCallerVtbl**)pobj)->run(pobj,r)
#define ITestCaller_countTestCases(pobj) (*(ITestCallerVtbl**)pobj)->countTestCases(pobj)
#define ITestCaller_getChildTestCount(pobj) (*(ITestCallerVtbl**)pobj)->getChildTestCount(pobj)
#define ITestCaller_getChildTestAt(pobj,i) (*(ITestCallerVtbl**)pobj)->getChildTestAt(pobj,i)
#define ITestCaller_findTest(pobj,n) (*(ITestCallerVtbl**)pobj)->findTest(pobj,n)

#define ITestCaller_init(pobj, n, s, t) (*(ITestCallerVtbl**)pobj)->init(pobj, n, s, t)
#define ITestCaller_addTestFixture(pobj, fixture) (*(ITestCallerVtbl**)pobj)->addTestFixture(pobj, fixture)


#endif/*__ACTTESTCALLER_H__*/

