/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__ACTHELPERMACRO_H__
#define	__ACTHELPERMACRO_H__

#ifdef __ACTTESTCASE_H__

#define ACT_TESTCASE_NEW(pTestCase,name,sup,tdw,run) \
    act_createInstance(ACTCLSID_TESTCASE, (void**) &pTestCase);\
    ITestCase_init(pTestCase,name,sup,tdw,run)

#define ACT_TESTCASE_DELETE(pTestCase) \
    ITestCase_release(pTestCase)

#endif /* __ACTTESTCASE_H__ */


#ifdef __ACTTESTRESULT_H__

#define ACT_TESTRESULT_NEW(pTestResult, pListener) \
    act_createInstance(ACTCLSID_TESTRESULT, (void**) &pTestResult); \
    ITestResult_init(pTestResult, pListener)

#define ACT_TESTRESULT_DELETE(pTestResult) \
    ITestResult_release(pTestResult)

#endif /* __ACTTESTRESULT_H__   */


#ifdef __ACTTESTSUITE_H__

#define ACT_TESTSUITE_NEW(pTestSuite,name) \
    act_createInstance(ACTCLSID_TESTSUITE, (void**) &pTestSuite);\
    ITestSuite_init(pTestSuite,name)

#define ACT_TESTSUITE_DELETE(pTestSuite) \
    ITestSuite_release(pTestSuite)

#define ACT_ADD_TEST(pTestSuite, pTest) \
    ITestSuite_addTest(pTestSuite, pTest)

#endif /* __ACTTESTSUITE_H__ */


#ifdef __ACTTESTCALLER_H__

#define ACT_TESTCALLER_NEW(pCaller_, name_, sup, tdw) \
    act_createInstance(ACTCLSID_TESTCALLER, (void**) &pCaller_);\
    ITestCaller_init(pCaller_, name_,setUp,tearDown);

#define ACT_TESTCALLER_DELETE(pCaller_) \
     ITestCaller_release(pCaller_)

#define ACT_ADD_FIXTURE(pCaller_, name_, pfnTest_) \
do {\
    ITestFixture * pFixture; \
    act_createInstance(ACTCLSID_TESTFIXTURE, (void**)&pFixture); \
    ITestFixture_init(pFixture, name_, pfnTest_); \
    ITestCaller_addTestFixture(pCaller_,pFixture); \
} while(0) 

#endif /* __ACTTESTCALLER_H__ */


#ifdef __ACTTESTREPEAT_H__

#define ACT_TESTREPEAT_NEW(repeater_,test_,tmrp_) \
    act_createInstance(ACTCLSID_TESTREPEAT, (void**) &repeater_);\
    ITestRepeat_init(repeater_, test_,tmrp_);


#define ACT_TESTREPEAT_DELETE(repeater_) \
     ITestRepeat_release(repeater_)

#endif /* __ACTTESTREPEAT_H__ */


#ifdef __ACTTESTRUNNER_H__

#define ACT_TESTRUNNER_NEW(runner_) \
    act_createInstance(ACTCLSID_TESTRUNNER, (void**) &runner_);

#define ACT_TESTRUNNER_DELETE(runner_) \
    ITestRunner_release(runner_)

#endif /* __ACTTESTRUNNER_H__ */


#define ACT_TESTRUNNERMFC_NEW(runner_) \
     _ITestRunnerMfc_new(&runner_)

#define ACT_TESTRUNNERMFC_DELETE(runner_) \
    ITestRunnerMfc_release(runner_)

#endif /* __ACTHELPERMACRO_H__ */

