/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTASSERTIMPL_H__
#define __ACTASSERTIMPL_H__

#ifdef	__cplusplus
extern "C" {
#endif

void act_addFailure(const char *msg, long line, const char *file);	/*TestCase.c*/

void act_assertImplementationInt(int expected,int actual, long line, const char *file);
void act_assertImplementationCStr(const char *expected,const char *actual, long line, const char *file);

#define ACT_TEST_ASSERT_EQUAL_STRING(expected,actual)\
	if (expected && actual && (act_strcmp(expected,actual)==0)) \
	{} \
	else {\
	act_assertImplementationCStr(expected,actual,__LINE__,__FILE__);\
	return;}

#define ACT_TEST_ASSERT_EQUAL_INT(expected,actual)\
	if (expected == actual) \
	{} \
	else {\
	act_assertImplementationInt(expected,actual,__LINE__,__FILE__);\
	return;}

#define ACT_TEST_ASSERT_NULL(pointer)\
	ACT_TEST_ASSERT_MESSAGE(pointer == NULL,#pointer " was not null.")

#define ACT_TEST_ASSERT_NOT_NULL(pointer)\
	ACT_TEST_ASSERT_MESSAGE(pointer != NULL,#pointer " was null.")

#define ACT_TEST_ASSERT_MESSAGE(condition, message)\
	if (condition) \
	{}\
	 else {\
	ACT_TEST_FAIL(message);}

#define ACT_TEST_ASSERT(condition)\
	if (condition) \
	{} \
	else {\
	ACT_TEST_FAIL(#condition);}

#define ACT_TEST_FAIL(message)\
	if (0)\
	{} \
	else {\
	act_addFailure(message,__LINE__,__FILE__);\
	return;}

#ifdef	__cplusplus
}
#endif

#endif /* __ACTTESTASSERT_H__ */

