/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "act.h"
#include "person.h"

Person* personRef;

static void setUp(void)
{
	personRef = Person_NewWithName("test tarou");
}

static void tearDown(void)
{
	Person_Delete(personRef);
}

static void testfullname(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("test tarou", (const char*) Person_fullName(personRef));
}

static void testfirstname(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("test", (const char*)Person_firstName(personRef));
}

static void testlastname(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", (const char*)Person_lastName(personRef));
}

static void testsetfullname(void)
{
	Person_SetFullName(personRef, "sample hanako");

	ACT_TEST_ASSERT_EQUAL_STRING("sample hanako", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("hanako", (const char*)Person_lastName(personRef));
}

static void testsetfirstname(void)
{
	Person_setFirstName(personRef, "sample");

	ACT_TEST_ASSERT_EQUAL_STRING("sample tarou", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", (const char*)Person_lastName(personRef));
}

static void testsetlastname(void)
{
	Person_setLastName(personRef, "hanako");

	ACT_TEST_ASSERT_EQUAL_STRING("test hanako", (const char*) Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("test", (const char*) Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("hanako", (const char*)Person_lastName(personRef));
}

static void testnullcharfullname(void)
{
	Person_SetFullName(personRef, "");

	ACT_TEST_ASSERT_EQUAL_STRING("", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("", (const char*)Person_lastName(personRef));
}

static void testnullpointerfullname(void)
{
	Person_SetFullName(personRef, NULL);

	ACT_TEST_ASSERT_NULL(Person_fullName(personRef));
	ACT_TEST_ASSERT_NULL(Person_firstName(personRef));
	ACT_TEST_ASSERT_NULL(Person_lastName(personRef));
}

static void testnosepfullname(void)
{
	Person_SetFullName(personRef, "sample");

	ACT_TEST_ASSERT_EQUAL_STRING("sample", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("", (const char*)Person_lastName(personRef));

	Person_setLastName(personRef, "tarou");
	ACT_TEST_ASSERT_EQUAL_STRING("sample tarou", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", (const char*)Person_lastName(personRef));

	Person_setFirstName(personRef, "test");
	ACT_TEST_ASSERT_EQUAL_STRING("test tarou", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("test", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", (const char*)Person_lastName(personRef));
}

ITest* PersonTest_tests(void)
{
    ITestCaller* pPersonTest;

    ACT_TESTCALLER_NEW(pPersonTest,"PersonTest",setUp,tearDown);
               ACT_ADD_FIXTURE(pPersonTest,"testfullname",testfullname);
		ACT_ADD_FIXTURE(pPersonTest,"testfirstname",testfirstname);
		ACT_ADD_FIXTURE(pPersonTest,"testlastname",testlastname);
		ACT_ADD_FIXTURE(pPersonTest,"testsetfullname",testsetfullname);
		ACT_ADD_FIXTURE(pPersonTest,"testsetfirstname",testsetfirstname);
		ACT_ADD_FIXTURE(pPersonTest,"testsetlastname",testsetlastname);
		ACT_ADD_FIXTURE(pPersonTest,"testnullcharfullname",testnullcharfullname);
		ACT_ADD_FIXTURE(pPersonTest,"testnullpointerfullname",testnullpointerfullname);
		ACT_ADD_FIXTURE(pPersonTest,"testnosepfullname",testnosepfullname);


	return (ITest*)pPersonTest;
}

