/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

/**
* @file  exConSample.c
* @brief Console Sample
*/
#include <stdio.h>

#include "person.h"
#include "counter.h"

int Counter_Sample(void);
int Person_Sample(void);

int main (int argc, const char* argv[])
{
    int ret;
    ret = Counter_Sample();
    ret += Person_Sample();
    return ret;
}

int Counter_Sample()
{
    Counter * pCounter;
    
    pCounter = Counter_New();
    
    printf("intial value = %d\n",Counter_GetValue(pCounter));
    printf("inc value = %d\n", Counter_Inc(pCounter));    
    Counter_SetValue(pCounter, 5);
    printf("set value = %d\n", Counter_GetValue(pCounter));
    printf("dec value = %d\n", Counter_Dec(pCounter));    
    Counter_Clr(pCounter);
    printf("clear value = %d\n",Counter_GetValue(pCounter)); 
    Counter_Delete(pCounter);

    return 0;
}

int Person_Sample(void)
{
    return 0;
}
