/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include <stdlib.h>
#include "counter.h"

Counter* Counter_Alloc(void)
{
	return (Counter*)malloc(sizeof(Counter));
}

void Counter_Free(Counter* pMe)
{
	free(pMe);
}

Counter* Counter_Ctor(Counter* pMe)
{
    if(pMe)
    {
	    pMe->m_nValue__ = 0;
    }
	return pMe;
}

Counter* Counter_New(void)
{
	return Counter_Ctor(Counter_Alloc());
}

void Counter_Delete(Counter* pMe)
{
    Counter_Free(pMe);
}

int Counter_GetValue(Counter* pMe)
{
	return pMe->m_nValue__;
}

void Counter_SetValue(Counter* pMe,int value)
{
	pMe->m_nValue__ = value;
}

int Counter_Inc(Counter* pMe)
{
	pMe->m_nValue__++;
	return pMe->m_nValue__;
}

int Counter_Dec(Counter* pMe)
{
	pMe->m_nValue__--;
	return pMe->m_nValue__;
}

void Counter_Clr(Counter* pMe)
{
	pMe->m_nValue__ = 0;
}
