#include "act.h"
#include "actTests.h"
#include "actMockTestCase.h"


#ifdef ACT_TESTCASE_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testName(void)
{
    ITestCase* pMockTestCase = actMockTestCase_case();
    ACT_TEST_ASSERT_EQUAL_STRING("actMockTestCase", ITest_name(pMockTestCase));
}

static void testCountTestCases(void)
{
    ITestCase* pMockTestCase = actMockTestCase_case();
    ACT_TEST_ASSERT_EQUAL_INT(1, ITest_countTestCases(pMockTestCase));
}

static void success_runTest(void)
{
}

static void testSuccess(void)
{
    ITestCase tcase;
    ITestResult result;
    
    ITestCase_Ctor(&tcase,"success",NULL,NULL,success_runTest);
    
    ITestResult_Ctor(&result,NULL);
    
    ITest_run(&tcase, &result);
    
    ACT_TEST_ASSERT_EQUAL_INT(1, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(0, result.failureCount);
}

static void failure_runTest(void)
{
    ACT_TEST_FAIL("");
}

static void testFailure(void)
{
    ITestCase tcase;
    ITestResult result;
    
    ITestCase_Ctor(&tcase,"failure",NULL,NULL,failure_runTest);
    
    ITestResult_Ctor(&result,NULL);
    
    ITest_run(&tcase, &result);	
    
    ACT_TEST_ASSERT_EQUAL_INT(1, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(1, result.failureCount);
}

ITest* actTestCaseTest_tests(void)
{
    //ACT_UNIT_TESTCALLER_CTOR(TestCaseTest,"TestCaseTest",setUp,tearDown);
    ACT_TESTCALLER_NEW(pTestCaseTest,"TestCaseTest",setUp,tearDown);
    ACT_ADD_FIXTURE(pTestCaseTest,"testName",testName);
    ACT_ADD_FIXTURE(pTestCaseTest,"testCountTestCases",testCountTestCases);
    ACT_ADD_FIXTURE(pTestCaseTest,"testSuccess",testSuccess);
    ACT_ADD_FIXTURE(pTestCaseTest,"testFailure",testFailure);
    
    return (ITest* )pTestCaseTest;
}

#endif // def ACT_TESTCASE_TESTS
