#ifndef __ACTTESTFIXTURELIST_H__
#define __ACTTESTFIXTURELIST_H__

// Double Linked List for ITest

#include "acttest.h"

#ifdef WIN32
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#endif // WIN32

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct __ITestNode ITestNode;


typedef struct __ITestList ITestList;


typedef struct __ITestListVtbl ITestListVtbl;


struct __ITestListVtbl
{
/// Head/Tail Access

	/// Returns the head element of the list (cannot be empty).
	const ITest* (* GetHead)(ITestList *pMe);
	/// Returns the tail element of the list (cannot be empty).
	const ITest* (* GetTail)(ITestList *pMe);

/// Operations

	/// Removes the element from the head of the list.
	ITest* (* RemoveHead)(ITestList *pMe, boolean bDataDelete);

	/// Removes the element from the tail of the list. 
	ITest* (* RemoveTail)(ITestList *pMe, boolean bDataDelete);
	
	/// Adds an element (or all the elements in another list) to the head of the list (makes a new head).
	ITestNode* (* AddHead)(ITestList *pMe, ITest* pItem);

	/// Adds an element (or all the elements in another list) to the tail of the list (makes a new tail).
	ITestNode* (* AddTail)(ITestList *pMe, ITest* pItem);
	
	/// Removes all the elements from this list.
	// bDataDelete = FALSE ̸ Ʈ ͵ ݵ ڰ delete Ѵ.
	void (* RemoveAll)(ITestList *pMe, boolean bDataDelete);	

/// Iteration

	/// Returns the position of the head element of the list.
	const ITestNode* (* GetHeadPosition)(ITestList *pMe);

	/// Returns the position of the tail element of the list.
	const ITestNode* (* GetTailPosition)(ITestList *pMe);
	
	/// Gets the next element for iterating.
	const ITest* (* GetNext)(ITestList *pMe, ITestNode** lppPosition);
	
	/// Gets the previous element for iterating.
	const ITest* (* GetPrev)(ITestList *pMe, ITestNode** lppPosition);

/// Retrieval/Modification

	/// Gets the element at a given position.
	const ITest* (* GetAt)(ITestList *pMe, ITestNode* position);

	/// Sets the element at a given position.
	void (* SetAt)(ITestList *pMe, ITestNode* pos, ITest* newElement, boolean bDeleteData);
	
	/// Removes an element from this list, specified by position.
	void (* RemoveAt)(ITestList *pMe, ITestNode* position, boolean bDeleteData);
	
/// Insertion

	/// Inserts a new element before a given position.
	ITestNode* (* InsertBefore)(ITestList *pMe, ITestNode* pos, ITest* newElement);

	/// Inserts a new element after a given position.
	ITestNode* (* InsertAfter)(ITestList *pMe, ITestNode* pos, ITest* newElement);
	
/// Searching

	/// Gets the position of an element specified by pointer value.
	const ITestNode* (* Find)(ITestList *pMe, ITest* searchValue, ITestNode* startAfter);

	/// Gets the position of an element specified by a zero-based index.
	const ITestNode* (* FindIndex)(ITestList *pMe, int nIndex);

	/// Gets the number of an element specified by pointer value.
	const int (* GetNo)(ITestList *pMe, ITest* searchValue, ITestNode* startAfter);
	
/// Status

	/// Returns the number of elements in this list.
	int (* GetCount)(ITestList *pMe);
	
	/// Tests for the empty list condition (no elements).
	boolean (* IsEmpty)(ITestList *pMe);
};

/// Construction/Destruction

    /** Allocates an empty ordered list. */
    ITestList* ITestList_New(void);    

    /** Free a TestCaseList, but don't free values if bDataDelete is false*/
    void ITestList_Delete(ITestList* pMe, boolean bDataDelete);

//#define ITestList_
/// Operations

	/// Removes the element from the head of the list.
#define ITestList_RemoveHead(pMe, bDataDelete) (*(ITestListVtbl**)pMe)->RemoveHead(pMe, bDataDelete)

	/// Removes the element from the tail of the list. 
#define ITestList_RemoveTail(pMe, bDataDelete) (*(ITestListVtbl**)pMe)->RemoveTail(pMe, bDataDelete)
	
	/// Adds an element (or all the elements in another list) to the head of the list (makes a new head).
#define ITestList_AddHead(pMe, pItem) (*(ITestListVtbl**)pMe)->AddHead(pMe, pItem)

	/// Adds an element (or all the elements in another list) to the tail of the list (makes a new tail).
#define ITestList_AddTail(pMe, pItem) (*(ITestListVtbl**)pMe)->AddTail(pMe, pItem)
	
	/// Removes all the elements from this list.
	// bDataDelete = FALSE ̸ Ʈ ͵ ݵ ڰ delete Ѵ.
#define ITestList_RemoveAll(pMe, bDataDelete) (*(ITestListVtbl**)pMe)->RemoveAll(pMe, bDataDelete)

/// Iteration

	/// Returns the position of the head element of the list.
#define ITestList_GetHeadPosition(pMe) (*(ITestListVtbl**)pMe)->GetHeadPosition(pMe)

	/// Returns the position of the tail element of the list.
#define ITestList_GetTailPosition(pMe) (*(ITestListVtbl**)pMe)->GetTailPosition(pMe)
	
	/// Gets the next element for iterating.
#define ITestList_GetNext(pMe, lppPosition) (*(ITestListVtbl**)pMe)->GetNext(pMe, lppPosition)
	
	/// Gets the previous element for iterating.
#define ITestList_GetPrev(pMe, lppPosition) (*(ITestListVtbl**)pMe)->GetPrev(pMe, lppPosition)

/// Retrieval/Modification

	/// Gets the element at a given position.
#define ITestList_GetAt(pMe, position) (*(ITestListVtbl**)pMe)->GetAt(pMe, position)

	/// Sets the element at a given position.
#define ITestList_SetAt(pMe, pos, newElement, bDeleteData) (*(ITestListVtbl**)pMe)->SetAt(pMe, pos, newElement, bDeleteData)
	
	/// Removes an element from this list, specified by position.
#define ITestList_RemoveAt(pMe, position, bDeleteData)(*(ITestListVtbl**)pMe)->RemoveAt(pMe, position, bDeleteData)(*(ITestListVtbl**)pMe)
	
/// Insertion

	/// Inserts a new element before a given position.
#define ITestList_InsertBefore(pMe, pos, newElement) (*(ITestListVtbl**)pMe)->InsertBefore(pMe, pos, newElement) 

	/// Inserts a new element after a given position.
#define ITestList_InsertAfter(pMe, pos, newElement) (*(ITestListVtbl**)pMe)->InsertAfter(pMe, pos, newElement)
	
/// Searching

	/// Gets the position of an element specified by pointer value.
#define ITestList_Find(pMe, searchValue, startAfter) (*(ITestListVtbl**)pMe)->Find(pMe, searchValue, startAfter) 

	/// Gets the position of an element specified by a zero-based index.
#define ITestList_FindIndex(pMe, nIndex) (*(ITestListVtbl**)pMe)->FindIndex(pMe, nIndex) 

	/// Gets the number of an element specified by pointer value.
#define ITestList_GetNo(pMe, searchValue, startAfter) (*(ITestListVtbl**)pMe)->GetNo(pMe, searchValue, startAfter)
	
/// Status

	/// Returns the number of elements in this list.
#define ITestList_GetCount(pMe) (*(ITestListVtbl**)pMe)->GetCount(pMe)
	
	/// Tests for the empty list condition (no elements).
#define ITestList_IsEmpty(pMe) (*(ITestListVtbl**)pMe)->IsEmpty(pMe) 

#ifdef	__cplusplus
}
#endif

#endif //  __ACTTESTFIXTURELIST_H__

