#ifndef __ACTTESTRESULT_H__
#define __ACTTESTRESULT_H__

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct __ITestListener	ITestListener;

/*typedef struct __ITestResult		ITestResult;*//* -> actTest.h*/

typedef struct __ITestResultVtbl ITestResultVtbl;

struct __ITestResultVtbl 
{
    void (*Delete)(ITestResult* pme);
	void (*init)(ITestResult* pme,ITestListener* listner);
	void (*startTest)(ITestResult* pme,ITest* test);
	void (*endTest)(ITestResult* pme,ITest* test);
	void (*addFailure)(ITestResult* pme,ITest* test,const char* msg,int line,const char* file);
};

struct __ITestResult {
	ITestResultVtbl* pvt;
	unsigned short runCount;
	unsigned short failureCount;
	ITestListener* listener;
};


ITestResult* ITestResult_New(ITestListener* pTestListener);
ITestResult* ITestResult_Ctor(ITestResult* pme, ITestListener* pTestListener);

#define ITestResult_Delete(po)              (*(ITestResultVtbl**)po)->Delete(po)
#define ITestResult_init(po,listener)       (*(ITestResultVtbl**)po)->init(po,listener)
#define ITestResult_startTest(po,test)      (*(ITestResultVtbl**)po)->startTest(po,test)
#define ITestResult_endTest(po,test)        (*(ITestResultVtbl**)po)->endTest(po,test)
#define ITestResult_addFailure(po,t,m,l,f)  (*(ITestResultVtbl**)po)->addFailure(po,t,m,l,f)

#ifdef	__cplusplus
}
#endif

#endif /* __ACTTESTRESULT_H__ */
