#include "act.h"
#include "actTestRunnerMfc.h"
#include "SimpleCalc.h"


SimpleCalc* pSimpleCalc;


static void setUp(void)
{
	pSimpleCalc = SimpleCalc_NewEx(2,1);
}

static void tearDown(void)
{
	SimpleCalc_Delete(pSimpleCalc);
}


static void testNewEx(void)
{
    int x,y;

    SimpleCalc_GetValue(pSimpleCalc, &x, &y);

	ACT_TEST_ASSERT_EQUAL_INT(2, x);
    ACT_TEST_ASSERT_EQUAL_INT(1, y);
}

static void testSum(void)
{
    int nSum;

    nSum = SimpleCalc_Sum(pSimpleCalc);
	ACT_TEST_ASSERT_EQUAL_INT(3, nSum);
	ACT_TEST_ASSERT_EQUAL_INT(1, nSum);
}


ITest* SimpleCalcTest_tests()
{
    ACT_TESTCALLER_NEW(pCaller, "SimpleCalcTest_tests",setUp, tearDown);

    ACT_ADD_FIXTURE(pCaller, "testNewEx", testNewEx);
    ACT_ADD_FIXTURE(pCaller, "testSum", testSum);
    
    return (ITest*) pCaller;
}

void TestRunner_Executor()
{
    /*
    IMfcTestRunner* pTestRunner;
    pTestRunner = IMfcTestRunner_New();

  	ITestRunner_start(pTestRunner);
		ITestRunner_addTest(pTestRunner, SimpleCalcTest_tests());
	ITestRunner_end(pTestRunner);
     */
    ITest* pTest;
    ITestRunnerMfc* pTestRunner;
    pTestRunner = ITestRunnerMfc_New();

    ITestRunnerMfc_start(pTestRunner);
    //__ITestRunnerMfc_start(pTestRunner);

    pTest = SimpleCalcTest_tests();
        ITestRunnerMfc_addTest(pTestRunner, pTest);
        ITestRunnerMfc_runTest(pTestRunner);
        
    
    ITestRunnerMfc_end(pTestRunner);

    ITestRunnerMfc_Delete(pTestRunner);
}
