// actMfcTestRunnerDlg.cpp : implementation file
//

#include "stdafx.h"
//#include "	\ add additional includes here"
#include "resource.h"
#include "actMfcTestRunnerDlg.h"

#include "act.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// actMfcTestRunnerDlg dialog


actMfcTestRunnerDlg::actMfcTestRunnerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(actMfcTestRunnerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(actMfcTestRunnerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void actMfcTestRunnerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(actMfcTestRunnerDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(actMfcTestRunnerDlg, CDialog)
	//{{AFX_MSG_MAP(actMfcTestRunnerDlg)
	ON_BN_CLICKED(ID_RUN, OnRun)
	ON_BN_CLICKED(IDC_BROWSE_TEST, OnBrowseTest)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// actMfcTestRunnerDlg message handlers

void actMfcTestRunnerDlg::SetTestList(ITestList *lstTest)
{
    m_lstTest = lstTest;
}

// ʱȭ ƾ InitUpdate ؾ .

static ITestResult result_;
static ITest* root_;

void actMfcTestRunnerDlg::OnRun() 
{
	// TODO: Add your control notification handler code here
    ITestNode* pNode;
    ITest* test;
    int nCount;
    int index;

    pNode = (ITestNode*) ITestList_GetHeadPosition(m_lstTest);
    nCount = ITestList_GetCount(m_lstTest);
    for(index = 0; index < nCount; index++)
    {
        test = (ITest*) ITestList_GetNext(m_lstTest, &pNode);
        root_ = test;
        ITest_run(test, &result_);
    }	
}

void actMfcTestRunnerDlg::OnBrowseTest() 
{
	// TODO: Add your control notification handler code here
	    char buf[16];
    if (result_.failureCount) {
        act_print("\nrun ");
        act_itoa(result_.runCount, buf, 10);
        act_print(buf);
        act_print(" failures ");
        act_itoa(result_.failureCount, buf, 10);
        act_print(buf);
        act_print("\n");
    } else {
        act_print("\nOK (");
        act_itoa(result_.runCount, buf, 10);
        act_print(buf);
        act_print(" tests)\n");
    }
}

static void __ITestRunner_startTest(ITestListener* self,ITest* test)
{
    act_print(".");
}

static void __ITestRunner_endTest(ITestListener* self,ITest* test)
{
    
}

static void __ITestRunner_addFailure(ITestListener* self,ITest* test,char* msg,int line,char* file)
{
    act_print("\n");
    act_print(ITest_name(root_));
    act_print(".");
    act_print(ITest_name(test));
    {
        char buf[16];
        act_print(" (");
        act_print(file);
        act_print(" ");
        act_itoa(line, buf, 10);
        act_print(buf);
        act_print(") ");
    }
    act_print(msg);
    act_print("\n");
}


static const ITestListenerVtbl g_ITestListenerVtbl = {
    (TestListnerStartTestCallBack)	__ITestRunner_startTest,
        (TestListnerEndTestCallBack)	__ITestRunner_endTest,
        (TestListnerAddFailureCallBack)	__ITestRunner_addFailure,
};


static const ITestListener testrunner_ = {
    (ITestListenerVtbl*)&g_ITestListenerVtbl,
};

BOOL actMfcTestRunnerDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

    ITestResult_Ctor(&result_,NULL);
    ITestResult_init(&result_, (ITestListener*) &testrunner_);
	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

