#if !defined(AFX_TREEHIERARCHYDLG_H__9A757152_C80F_473A_8328_3508A78E0D97__INCLUDED_)
#define AFX_TREEHIERARCHYDLG_H__9A757152_C80F_473A_8328_3508A78E0D97__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TreeHierarchyDlg.h : header file
//

#include <vector>
#include "DynamicWindow/cdxCDynamicDialog.h"
#include "actTest.h"
/////////////////////////////////////////////////////////////////////////////
// TreeHierarchyDlg dialog

class TreeHierarchyDlg : public cdxCDynamicDialog
{
// Construction
public:
	TreeHierarchyDlg(CWnd* pParent = NULL);   // standard constructor

	void setRootTest(ITest *test);
	ITest *getSelectedTest() const;

	static bool isSuite(ITest *test);

// Dialog Data
	//{{AFX_DATA(TreeHierarchyDlg)
	enum { IDD = ACT_UNIT_TEST_RUNNER_IDD_DIALOG_TEST_HIERARCHY };
	CTreeCtrl	m_treeTests;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TreeHierarchyDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual void initializeLayout();
    void storeDialogBounds();	

	// Generated message map functions
	//{{AFX_MSG(TreeHierarchyDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnCancel();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();

private:
  typedef std::vector<ITest *> Tests;

	void fillTree();
	HTREEITEM addTest(ITest *test, 
                      HTREEITEM hParent);
	void addTestSuiteChildrenTo(ITest *suite, 
                                HTREEITEM hItemSuite );
    void sortByName(Tests &tests) const;
	ITest *findSelectedTest();

  enum
  {
    imgSuite =0,
    imgUnitTest,
  };

	CImageList m_imageList;
	ITest *m_selectedTest;
	ITest *m_rootTest;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TREEHIERARCHYDLG_H__9A757152_C80F_473A_8328_3508A78E0D97__INCLUDED_)
