
#include "actconfig.h"
#include "actcomdef.h"
#include "actstdlib.h"
#include "acttest.h"

#include "acttestsuite.h"
#include "acttestsuite_private.h"

static uint32   __ITestSuite_AddRef(ITestSuite* pMe);
static void     __ITestSuite_Delete(ITestSuite* pMe);
static char*    __ITestSuite_name(ITestSuite* self);
static void     __ITestSuite_run(ITestSuite* self,ITestResult* result);
static int      __ITestSuite_countTestCases(ITestSuite* self);

static const ITestSuiteVtbl g_ITestSuiteVtbl = 
{
    (PFNTestAddRef)     __ITestSuite_AddRef,
    (PFNTestDelete)     __ITestSuite_Delete,
    (PFNTestName)       __ITestSuite_name,
    (PFNTestRun)        __ITestSuite_run,
    (PFNCountTestCases) __ITestSuite_countTestCases,
                        __ITestSuite_AddTest
};

ITestSuite* ITestSuite_New(char* name)
{
    ITestSuite* pMe;
    pMe = (ITestSuite*) act_malloc(sizeof(ITestSuite));
    
    return ITestSuite_Ctor(pMe, name);
}

static uint32   __ITestSuite_AddRef(ITestSuite* pMe)
{
    return ++pMe->m_cRef;
}

static void __ITestSuite_Delete(ITestSuite* pMe)
{
    if(--pMe->m_cRef == 0)
    {
        ITestList_Delete(pMe->m_lstTest__, TRUE);
        act_free(pMe);
    }
}


ITestSuite* ITestSuite_Ctor(ITestSuite* pme, char* name)
{
    pme->pvt = (ITestSuiteVtbl*) &g_ITestSuiteVtbl;
    pme->m_cRef = 1;
    act_strncpy(pme->name, name, ACT_TEST_NAME_LENGTH);
    
    pme->m_lstTest__ = ITestList_New();
    
    return pme;
}


static char* __ITestSuite_name(ITestSuite* self)
{
    return self->name;
}

static void __ITestSuite_run(ITestSuite* self,ITestResult* result)
{
    ITest* test;
    ITestNode* pNode;
    
    int i;
    int numberOfTests; 
    
    
    if(self->m_lstTest__)
    {
        numberOfTests = ITestList_GetCount(self->m_lstTest__);
        pNode = (ITestNode*) ITestList_GetHeadPosition(self->m_lstTest__);
        
        for(i = 0; i < numberOfTests; i++)
        {
            test = (ITest*) ITestList_GetNext(self->m_lstTest__, &pNode);
            ITest_run(test, result);
        }
    }
    
#if 0     
    if (self->tests) {
        for (i=0; i<self->numberOfTests; i++) {
            test = self->tests[i];
            ITest_run(test, result);
        }
    }
#endif
    
}

static int __ITestSuite_countTestCases(ITestSuite* self)
{
    ITest* test;
    ITestNode* pNode;
    
    int count = 0;
    int i;
    int numberOfTests; 
    
    if(self->m_lstTest__)
    {
        numberOfTests = ITestList_GetCount(self->m_lstTest__);
        pNode = (ITestNode*) ITestList_GetHeadPosition(self->m_lstTest__);
        
        for(i = 0; i < numberOfTests; i++)
        {
            test = (ITest*) ITestList_GetNext(self->m_lstTest__, &pNode);
            count += ITest_countTestCases(test);
        }
    }
#if 0
    if (self->tests) {
        for (i=0; i<self->numberOfTests; i++) {
            test = self->tests[i];
            count += ITest_countTestCases(test);
        }
    }
#endif
    
    return count;
}

static void __ITestSuite_AddTest(ITestSuite* pMe, ITest* pITest)
{
    //    pMe->m_lstTest;
    ITestList_AddTail(pMe->m_lstTest__, pITest);
}


