#ifndef __ACTTESTFIXTURELIST_H__
#define __ACTTESTFIXTURELIST_H__

// Double Linked List for ITestFixture

#include "acttestfixture.h"

#ifdef WIN32
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#endif // WIN32


typedef struct __ITestFixtureNode ITestFixtureNode;


typedef struct __ITestFixtureList ITestFixtureList;


typedef struct __ITestFixtureListVtbl ITestFixtureListVtbl;


struct __ITestFixtureListVtbl
{
/// Head/Tail Access

	/// Returns the head element of the list (cannot be empty).
	const ITestFixture* (* GetHead)(ITestFixtureList *pMe);
	/// Returns the tail element of the list (cannot be empty).
	const ITestFixture* (* GetTail)(ITestFixtureList *pMe);

/// Operations

	/// Removes the element from the head of the list.
	ITestFixture* (* RemoveHead)(ITestFixtureList *pMe, boolean bDataDelete);

	/// Removes the element from the tail of the list. 
	ITestFixture* (* RemoveTail)(ITestFixtureList *pMe, boolean bDataDelete);
	
	/// Adds an element (or all the elements in another list) to the head of the list (makes a new head).
	ITestFixtureNode* (* AddHead)(ITestFixtureList *pMe, ITestFixture* pItem);

	/// Adds an element (or all the elements in another list) to the tail of the list (makes a new tail).
	ITestFixtureNode* (* AddTail)(ITestFixtureList *pMe, ITestFixture* pItem);
	
	/// Removes all the elements from this list.
	// bDataDelete = FALSE ̸ Ʈ ͵ ݵ ڰ delete Ѵ.
	void (* RemoveAll)(ITestFixtureList *pMe, boolean bDataDelete);	

/// Iteration

	/// Returns the position of the head element of the list.
	const ITestFixtureNode* (* GetHeadPosition)(ITestFixtureList *pMe);

	/// Returns the position of the tail element of the list.
	const ITestFixtureNode* (* GetTailPosition)(ITestFixtureList *pMe);
	
	/// Gets the next element for iterating.
	const ITestFixture* (* GetNext)(ITestFixtureList *pMe, ITestFixtureNode** lppPosition);
	
	/// Gets the previous element for iterating.
	const ITestFixture* (* GetPrev)(ITestFixtureList *pMe, ITestFixtureNode** lppPosition);

/// Retrieval/Modification

	/// Gets the element at a given position.
	const ITestFixture* (* GetAt)(ITestFixtureList *pMe, ITestFixtureNode* position);

	/// Sets the element at a given position.
	void (* SetAt)(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement, boolean bDeleteData);
	
	/// Removes an element from this list, specified by position.
	void (* RemoveAt)(ITestFixtureList *pMe, ITestFixtureNode* position, boolean bDeleteData);
	
/// Insertion

	/// Inserts a new element before a given position.
	ITestFixtureNode* (* InsertBefore)(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement);

	/// Inserts a new element after a given position.
	ITestFixtureNode* (* InsertAfter)(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement);
	
/// Searching

	/// Gets the position of an element specified by pointer value.
	const ITestFixtureNode* (* Find)(ITestFixtureList *pMe, ITestFixture* searchValue, ITestFixtureNode* startAfter);

	/// Gets the position of an element specified by a zero-based index.
	const ITestFixtureNode* (* FindIndex)(ITestFixtureList *pMe, int nIndex);

	/// Gets the number of an element specified by pointer value.
	const int (* GetNo)(ITestFixtureList *pMe, ITestFixture* searchValue, ITestFixtureNode* startAfter);
	
/// Status

	/// Returns the number of elements in this list.
	int (* GetCount)(ITestFixtureList *pMe);
	
	/// Tests for the empty list condition (no elements).
	boolean (* IsEmpty)(ITestFixtureList *pMe);
};

/// Construction/Destruction

    /** Allocates an empty ordered list. */
    ITestFixtureList* ITestFixtureList_New(void);    

    /** Free a TestCaseList, but don't free values if bDataDelete is false*/
    void ITestFixtureList_Delete(ITestFixtureList* pMe, boolean bDataDelete);

//#define ITestFixtureList_
/// Operations

	/// Removes the element from the head of the list.
#define ITestFixtureList_RemoveHead(pMe, bDataDelete) (*(ITestFixtureListVtbl**)pMe)->RemoveHead(pMe, bDataDelete)

	/// Removes the element from the tail of the list. 
#define ITestFixtureList_RemoveTail(pMe, bDataDelete) (*(ITestFixtureListVtbl**)pMe)->RemoveTail(pMe, bDataDelete)
	
	/// Adds an element (or all the elements in another list) to the head of the list (makes a new head).
#define ITestFixtureList_AddHead(pMe, pItem) (*(ITestFixtureListVtbl**)pMe)->AddHead(pMe, pItem)

	/// Adds an element (or all the elements in another list) to the tail of the list (makes a new tail).
#define ITestFixtureList_AddTail(pMe, pItem) (*(ITestFixtureListVtbl**)pMe)->AddTail(pMe, pItem)
	
	/// Removes all the elements from this list.
	// bDataDelete = FALSE ̸ Ʈ ͵ ݵ ڰ delete Ѵ.
#define ITestFixtureList_RemoveAll(pMe, bDataDelete) (*(ITestFixtureListVtbl**)pMe)->RemoveAll(pMe, bDataDelete)

/// Iteration

	/// Returns the position of the head element of the list.
#define ITestFixtureList_GetHeadPosition(pMe) (*(ITestFixtureListVtbl**)pMe)->GetHeadPosition(pMe)

	/// Returns the position of the tail element of the list.
#define ITestFixtureList_GetTailPosition(pMe) (*(ITestFixtureListVtbl**)pMe)->GetTailPosition(pMe)
	
	/// Gets the next element for iterating.
#define ITestFixtureList_GetNext(pMe, lppPosition) (*(ITestFixtureListVtbl**)pMe)->GetNext(pMe, lppPosition)
	
	/// Gets the previous element for iterating.
#define ITestFixtureList_GetPrev(pMe, lppPosition) (*(ITestFixtureListVtbl**)pMe)->GetPrev(pMe, lppPosition)

/// Retrieval/Modification

	/// Gets the element at a given position.
#define ITestFixtureList_GetAt(pMe, position) (*(ITestFixtureListVtbl**)pMe)->GetAt(pMe, position)

	/// Sets the element at a given position.
#define ITestFixtureList_SetAt(pMe, pos, newElement, bDeleteData) (*(ITestFixtureListVtbl**)pMe)->SetAt(pMe, pos, newElement, bDeleteData)
	
	/// Removes an element from this list, specified by position.
#define ITestFixtureList_RemoveAt(pMe, position, bDeleteData)(*(ITestFixtureListVtbl**)pMe)->RemoveAt(pMe, position, bDeleteData)(*(ITestFixtureListVtbl**)pMe)
	
/// Insertion

	/// Inserts a new element before a given position.
#define ITestFixtureList_InsertBefore(pMe, pos, newElement) (*(ITestFixtureListVtbl**)pMe)->InsertBefore(pMe, pos, newElement) 

	/// Inserts a new element after a given position.
#define ITestFixtureList_InsertAfter(pMe, pos, newElement) (*(ITestFixtureListVtbl**)pMe)->InsertAfter(pMe, pos, newElement)
	
/// Searching

	/// Gets the position of an element specified by pointer value.
#define ITestFixtureList_Find(pMe, searchValue, startAfter) (*(ITestFixtureListVtbl**)pMe)->Find(pMe, searchValue, startAfter) 

	/// Gets the position of an element specified by a zero-based index.
#define ITestFixtureList_FindIndex(pMe, nIndex) (*(ITestFixtureListVtbl**)pMe)->FindIndex(pMe, nIndex) 

	/// Gets the number of an element specified by pointer value.
#define ITestFixtureList_GetNo(pMe, searchValue, startAfter) (*(ITestFixtureListVtbl**)pMe)->GetNo(pMe, searchValue, startAfter)
	
/// Status

	/// Returns the number of elements in this list.
#define ITestFixtureList_GetCount(pMe) (*(ITestFixtureListVtbl**)pMe)->GetCount(pMe)
	
	/// Tests for the empty list condition (no elements).
#define ITestFixtureList_IsEmpty(pMe) (*(ITestFixtureListVtbl**)pMe)->IsEmpty(pMe) 


#endif //  __ACTTESTFIXTURELIST_H__

