#ifndef __ACTTESTFIXTURE_H__
#define __ACTTESTFIXTURE_H__



typedef void(*PFNTEST)(void);

typedef struct __ITestFixture	ITestFixture;

typedef struct __ITestFixtureVtbl ITestFixtureVtbl;

struct __ITestFixtureVtbl {
    void    (*Delete)(ITestFixture* po);
	char*	(*name)(ITestFixture* po);
	PFNTEST (*test)(ITestFixture* po);
};

typedef void(*PFNTESTFUNC) (void);

typedef enum __ACT_TEST_TYPE ACT_TEST_TYPE;

enum __ACT_TEST_TYPE{
    ACT_TEST_AUTO_SYNC,
    ACT_TEST_AUTO_ASYNC,
    ACT_TEST_INT_PASSFAIL,
    ACT_TEST_INT_ASYNC,    
    ACT_TEST_TYPE_MAX
};

struct __ITestFixture {
	ITestFixtureVtbl* pvt;
	char name[ACT_TEST_NAME_LENGTH];
	void(*test)(void);
#if 0
    PFNTESTFUNC m_pfnTest;
    PFNTESTFUNC m_pfnResume;    
    ACT_TEST_TYPE   m_eTestType;
    uint16              m_cntRepeat;
    char                m_name[ACT_TEST_NAME_LENGTH];
    boolean         m_bSel;
    boolean         m_bOwnDisp;
    uint32          m_dwExtra;
#endif    
};

typedef struct __ITestInfo ITestInfo;
struct __ITestInfo {
    char m_szName[ACT_TEST_NAME_LENGTH];
    ACT_TEST_TYPE m_test_type;
};

ITestFixture* ITestFixture_New(char* name, PFNTEST test);
// move to private funtion
//void              ITestFixture_Delete(ITestFixture* pMe);
ITestFixture* ITestFixture_Ctor(ITestFixture* pme, char* name, PFNTEST test);

#define ITestFixture_Delete(p) (*(ITestFixtureVtbl**)p)->Delete(p)
#define ITestFixture_name(p) (*(ITestFixtureVtbl**)p)->name(p)
#define ITestFixture_test(p) (*(ITestFixtureVtbl**)p)->test(p)





#endif //  __ACTTESTFIXTURE_H__

