#include "act.h"

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void teststrcpy(void)
{
	char buf[32];
	char *p;

	p = ACT_strcpy(buf, "test");
	ACT_TEST_ASSERT_EQUAL_STRING("test", buf);
	ACT_TEST_ASSERT( p == buf );
}

static void teststrncpy(void)
{
	char buf[32];
	char *p;

	p = ACT_strncpy(buf, "test", 8);
	ACT_TEST_ASSERT( buf[0]=='t' );
	ACT_TEST_ASSERT( buf[1]=='e' );
	ACT_TEST_ASSERT( buf[2]=='s' );
	ACT_TEST_ASSERT( buf[3]=='t' );
	ACT_TEST_ASSERT( buf[4]=='\0' );
	ACT_TEST_ASSERT( buf[5]=='\0' );
	ACT_TEST_ASSERT( buf[6]=='\0' );
	ACT_TEST_ASSERT( buf[7]=='\0' );
	
	p = ACT_strncpy(buf, "", 4);
	ACT_TEST_ASSERT( buf[0]=='\0' );
	ACT_TEST_ASSERT( buf[1]=='\0' );
	ACT_TEST_ASSERT( buf[2]=='\0' );
	ACT_TEST_ASSERT( buf[3]=='\0' );

	ACT_strcpy(buf, "_xxxx_");
	p = ACT_strncpy(buf+1, "test", 4);
	ACT_TEST_ASSERT( buf[0]=='_' );
	ACT_TEST_ASSERT( buf[1]=='t' );
	ACT_TEST_ASSERT( buf[2]=='e' );
	ACT_TEST_ASSERT( buf[3]=='s' );
	ACT_TEST_ASSERT( buf[4]=='t' );
	ACT_TEST_ASSERT( buf[5]=='_' );
	ACT_TEST_ASSERT( buf[6]=='\0' );
}

static void teststrcat(void)
{
	char buf[64];

	ACT_strcpy(buf,"sample");
	ACT_strcat(buf," extra string");
	ACT_TEST_ASSERT_EQUAL_STRING("sample extra string", buf);

	ACT_strcpy(buf,"");
	ACT_strcat(buf,"sample");
	ACT_TEST_ASSERT_EQUAL_STRING("sample", buf);
}

static void teststrncat(void)
{
	char buf[64];

	ACT_strcpy(buf,"sample");
	ACT_strncat(buf," extra string",13);
	ACT_TEST_ASSERT_EQUAL_STRING("sample extra string", buf);

	ACT_strcpy(buf,"This is the initial string!");
	ACT_strncat(buf," extra text to add to the string", 19);
	ACT_TEST_ASSERT_EQUAL_STRING("This is the initial string! extra text to add ", buf);
}

static void teststrlen(void)
{
	ACT_TEST_ASSERT( ACT_strlen("test")==4 );
	ACT_TEST_ASSERT( ACT_strlen("")==0 );
}

static void teststrcmp(void)
{
	ACT_TEST_ASSERT( ACT_strcmp("aaa","aaa") == 0 );
	ACT_TEST_ASSERT( ACT_strcmp("aaa","bbb") != 0 );
	ACT_TEST_ASSERT( ACT_strcmp("aaa","AAA") != 0 );
	ACT_TEST_ASSERT( ACT_strcmp("Test","TestCase") != 0 );
	ACT_TEST_ASSERT( ACT_strcmp("TestCase","Test") != 0 );
	ACT_TEST_ASSERT( ACT_strcmp("","") == 0 );
}

static void testitoa(void)
{
	char buf[33];
	char *p;

	p = ACT_itoa(10, buf, 2);
	ACT_TEST_ASSERT_EQUAL_STRING("1010", buf);
	ACT_TEST_ASSERT(p == buf);

	p = ACT_itoa(10, buf, 8);
	ACT_TEST_ASSERT_EQUAL_STRING("12", buf);
	ACT_TEST_ASSERT(p == buf);

	p = ACT_itoa(10, buf, 10);
	ACT_TEST_ASSERT_EQUAL_STRING("10", buf);
	ACT_TEST_ASSERT(p == buf);

	p = ACT_itoa(10, buf, 16);
	ACT_TEST_ASSERT_EQUAL_STRING("a", buf);
	ACT_TEST_ASSERT(p == buf);

	p = ACT_itoa(-10, buf, 2);
	ACT_TEST_ASSERT_EQUAL_STRING("11111111111111111111111111110110", buf);
	ACT_TEST_ASSERT(p == buf);

	p = ACT_itoa(-10, buf, 8);
	ACT_TEST_ASSERT_EQUAL_STRING("37777777766", buf);
	ACT_TEST_ASSERT(p == buf);

	p = ACT_itoa(-10, buf, 10);
	ACT_TEST_ASSERT_EQUAL_STRING("-10", buf);
	ACT_TEST_ASSERT(p == buf);

	p = ACT_itoa(-10, buf, 16);
	ACT_TEST_ASSERT_EQUAL_STRING("fffffff6", buf);
	ACT_TEST_ASSERT(p == buf);
}

static void testmemcmp(void)
{
	ACT_TEST_ASSERT(ACT_memcmp("sample","sample",6) == 0);
	ACT_TEST_ASSERT(ACT_memcmp("sample","SAMPLE",6) != 0);
	ACT_TEST_ASSERT(ACT_memcmp("sample","sample",0) == 0);
	ACT_TEST_ASSERT(ACT_memcmp("sample","samPLE",3) == 0);
}

#if 0
#define ACT_UNIT_ADD_FIXTURE(pCaller_, name_, pTest_) \
do { \
	static ITestFixture fixture; \
	ITestFixture_Ctor(&fixture,name_,pTest_);\
	ITestCaller_AddTestFixture(pCaller_, &fixture);\
} while(0)

#endif

ITest* ACTStdLibTest_tests(void)
{
	static ITestCaller ACTStdLibTest;
	ITestCaller_Ctor(&ACTStdLibTest,"ACTStdLibTest",setUp,tearDown);

	{
		static ITestFixture fixture;
		ITestFixture_Ctor(&fixture,"teststrcpy",teststrcpy);
		ITestCaller_AddTestFixture(&ACTStdLibTest, &fixture);
	}
	ACT_UNIT_ADD_FIXTURE(&ACTStdLibTest,"teststrcat",teststrcat);
	ACT_UNIT_ADD_FIXTURE(&ACTStdLibTest,"teststrncat",teststrncat);
	ACT_UNIT_ADD_FIXTURE(&ACTStdLibTest,"teststrlen",teststrlen);
	ACT_UNIT_ADD_FIXTURE(&ACTStdLibTest,"teststrcmp",teststrcmp);
	ACT_UNIT_ADD_FIXTURE(&ACTStdLibTest,"testitoa",testitoa);
	ACT_UNIT_ADD_FIXTURE(&ACTStdLibTest,"testmemcmp",testitoa);
	/*
	EMB_UNIT_TESTFIXTURES(fixtures) {
		new_TestFixture("teststrcpy",teststrcpy),
		new_TestFixture("teststrcpy",teststrncpy),
		new_TestFixture("teststrcat",teststrcat),
		new_TestFixture("teststrncat",teststrncat),
		new_TestFixture("teststrlen",teststrlen),
		new_TestFixture("teststrcmp",teststrcmp),
		new_TestFixture("testitoa",testitoa),
		new_TestFixture("testmemcmp",testitoa),
	};
	*/
	//EMB_UNIT_TESTCALLER(ACTStdLibTest,"ACTStdLibTest",setUp,tearDown,fixtures);

	return (ITest*)&ACTStdLibTest;
}
