#include <act.h>

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void verify(ITestCase* test)
{
	ITestResult result;
	ITestResult_Ctor(&result, NULL);

	ITest_run(test,&result);
	//test->isa->run(test,&result);

	if (result.failureCount == 0)
	{
		ACT_TEST_FAIL("fail");
	}
}

static void assert_equal_string_runTest(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("123","456");
}

static void assert_equal_int_runTest(void)
{
	ACT_TEST_ASSERT_EQUAL_INT(123,456);
}

static void assert_null_runTest(void)
{
	char *p="";
	ACT_TEST_ASSERT_NULL(p);
}

static void assert_not_null_runTest(void)
{
	char *p=NULL;
	ACT_TEST_ASSERT_NOT_NULL(p);
}

static void assert_message_runTest(void)
{
	ACT_TEST_ASSERT_MESSAGE(0,"0");
}

static void assert_runTest(void)
{
	ACT_TEST_ASSERT(0);
}

static void testASSERT_EQUAL_STRING(void)
{
	ITestCase tcase;
	ITestCase_Ctor(&tcase, "assert_equal_string",NULL,NULL,assert_equal_string_runTest);
	verify(&tcase);
}

static void testASSERT_EQUAL_INT(void)
{
	ITestCase tcase;
	ITestCase_Ctor(&tcase,"assert_equal_int",NULL,NULL,assert_equal_int_runTest);
	verify(&tcase);
}

static void testASSERT_NULL(void)
{
	ITestCase tcase;
	ITestCase_Ctor(&tcase,"assert_null",NULL,NULL,assert_null_runTest);
	verify(&tcase);
}

static void testASSERT_NOT_NULL(void)
{
	ITestCase tcase;
	ITestCase_Ctor(&tcase,"assert_not_null",NULL,NULL,assert_not_null_runTest);
	verify(&tcase);
}

static void testASSERT_MESSAGE(void)
{
	ITestCase tcase;
	ITestCase_Ctor(&tcase,"assert_message",NULL,NULL,assert_message_runTest);
	verify(&tcase);
}

static void testASSERT(void)
{	
	ITestCase tcase;
	ITestCase_Ctor(&tcase,"assert",NULL,NULL,assert_runTest);
	verify(&tcase);
}

#if 0
#define ACT_UNIT_TESTCALLER_CTOR(caller_, name_, sup, tdw) \
	static ITestCaller caller_;\
	ITestCaller_Ctor(&caller_,name_,sup,tdw)

#endif

ITest* assertTest_tests(void)
{
	ACT_UNIT_TESTCALLER_CTOR(AssertTest,"AssertTest",setUp,tearDown);
		ACT_UNIT_ADD_FIXTURE(&AssertTest, "testASSERT_EQUAL_STRING",testASSERT_EQUAL_STRING);
		ACT_UNIT_ADD_FIXTURE(&AssertTest,"testASSERT_EQUAL_INT",testASSERT_EQUAL_INT);
		ACT_UNIT_ADD_FIXTURE(&AssertTest,"testASSERT_NULL",testASSERT_NULL);
		ACT_UNIT_ADD_FIXTURE(&AssertTest,"testASSERT_NOT_NULL",testASSERT_NOT_NULL);
		ACT_UNIT_ADD_FIXTURE(&AssertTest,"testASSERT_MESSAGE",testASSERT_MESSAGE);
		ACT_UNIT_ADD_FIXTURE(&AssertTest,"testASSERT",testASSERT);
	
	return (ITest*)&AssertTest;
}
