#include "act.h"

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testTestResult_result(void)
{
	ITestResult result;
	ITestResult_Ctor(&result,NULL);

	ACT_TEST_ASSERT_EQUAL_INT(0, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(0, result.failureCount);
}

static void testTestResult_startTest(void)
{
	ITestResult result;
	ITestResult_Ctor(&result,NULL);

	ITestResult_startTest(&result,NULL);

	ACT_TEST_ASSERT_EQUAL_INT(1, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(0, result.failureCount);
}

static void testTestResult_endTest(void)
{
	ITestResult result;
	ITestResult_Ctor(&result,NULL);

	ITestResult_endTest(&result,NULL);

	ACT_TEST_ASSERT_EQUAL_INT(0, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(0, result.failureCount);
}

static void testTestResult_addFailure(void)
{
	ITestResult result;
	ITestResult_Ctor(&result,NULL);

	ITestResult_addFailure(&result,NULL,"",0,"");

	ACT_TEST_ASSERT_EQUAL_INT(0, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(1, result.failureCount);
}

ITest* TestResultTest_tests(void)
{
	ACT_UNIT_TESTCALLER_CTOR(TestResultTest,"TestResultTest",setUp,tearDown);
		ACT_UNIT_ADD_FIXTURE(&TestResultTest,"testTestResult_result",testTestResult_result);
		ACT_UNIT_ADD_FIXTURE(&TestResultTest,"testTestResult_startTest",testTestResult_startTest);
		ACT_UNIT_ADD_FIXTURE(&TestResultTest,"testTestResult_endTest",testTestResult_endTest);
		ACT_UNIT_ADD_FIXTURE(&TestResultTest,"testTestResult_addFailure",testTestResult_addFailure);
	
	return (ITest*)&TestResultTest;
}
