
#include "actConfig.h"
#include "actStdLib.h"
#include "actTest.h"
#include "actRepeatedTest.h"

static char* __IRepeatedTest_name(IRepeatedTest* pme);
static void __IRepeatedTest_run(IRepeatedTest* pme,ITestResult* result);
static int __IRepeatedTest_countTestCases(IRepeatedTest* pme);

static const ITestVtbl g_ITestVtbl = 
{
	(PFNTestName)		__IRepeatedTest_name,
	(PFNTestRun)		__IRepeatedTest_run,
	(PFNCountTestCases)	__IRepeatedTest_countTestCases,
};

static char* __IRepeatedTest_name(IRepeatedTest* pme)
{	
	return ITest_name(pme->test);
}

static void __IRepeatedTest_run(IRepeatedTest* pme,ITestResult* result)
{
	int i;
	ITest* test = pme->test;
	for (i=0; i<pme->timesRepeat; i++) {
		ITest_run(test, result);
	}
}

static int __IRepeatedTest_countTestCases(IRepeatedTest* pme)
{
	return ITest_countTestCases(pme->test) * pme->timesRepeat;
}


IRepeatedTest* IRepeatedTest_Ctor(IRepeatedTest* pme, ITest* test, int timesRepeat)
{
	pme->pvt = (ITestVtbl*) &g_ITestVtbl;
	pme->test = test;
	pme->timesRepeat = timesRepeat;

	return pme;
}
