
#include "actConfig.h"
#include "actStdLib.h"
#include "actTest.h"
#include "actTestSuite.h"

static char*	__ITestSuite_name(ITestSuite* self);
static void		__ITestSuite_run(ITestSuite* self,ITestResult* result);
static int		__ITestSuite_countTestCases(ITestSuite* self);

static const ITestVtbl g_ITestVtbl = 
{
	(PFNTestName)		__ITestSuite_name,
	(PFNTestRun)		__ITestSuite_run,
	(PFNCountTestCases)	__ITestSuite_countTestCases,
};

static char* __ITestSuite_name(ITestSuite* self)
{
	return self->name;
}

static void __ITestSuite_run(ITestSuite* self,ITestResult* result)
{
	int i;
	ITest* test;
	if (self->tests) {
		for (i=0; i<self->numberOfTests; i++) {
			test = self->tests[i];
			ITest_run(test, result);
		}
	}
}

static int __ITestSuite_countTestCases(ITestSuite* self)
{
	int count = 0;
	int i;
	ITest* test;
	if (self->tests) {
		for (i=0; i<self->numberOfTests; i++) {
			test = self->tests[i];
			count += ITest_countTestCases(test);
		}
	}
	return count;
}

ITestSuite* ITestSuite_Ctor(ITestSuite* pme, char* name, int numberOfTests, ITest** tests)
{
	pme->pvt = (ITestVtbl*) &g_ITestVtbl;
	ACT_strncpy(pme->name, name, TEST_NAME_STRING_BUFFER_MAX);
	pme->numberOfTests = numberOfTests;
	pme->tests = tests;

	return pme;
}
