
#include "actconfig.h"
#include "actstdlib.h"
#include "actTest.h"
#include "actTestListener.h"
#include "actTestResult.h"
#include "actTestRunner.h"

static void __ITestRunner_startTest(ITestListener* self,ITest* test);
static void __ITestRunner_endTest(ITestListener* self,ITest* test);
static void __ITestRunner_addFailure(ITestListener* self,ITest* test,char* msg,int line,char* file);

static void __ITestRunner_start(ITestRunner* pme);
static void __ITestRunner_addTest(ITestRunner* pme, ITest* test);
static void __ITestRunner_run(ITestRunner* pme);
static void __ITestRunner_end(ITestRunner* pme);

static const ITestListenerVtbl g_ITestListenerVtbl = {
	(TestListnerStartTestCallBack)	__ITestRunner_startTest,
	(TestListnerEndTestCallBack)	__ITestRunner_endTest,
	(TestListnerAddFailureCallBack)	__ITestRunner_addFailure,
};

static ITestRunnerVtbl g_ITestRunnerVtbl = {
	__ITestRunner_start,
	__ITestRunner_addTest,
	__ITestRunner_run,
	__ITestRunner_end,
};

static const ITestListener testrunner_ = {
	(ITestListenerVtbl*)&g_ITestListenerVtbl,
};

static ITestResult result_;
static ITest* loc_pRootTest__;

static void __ITestRunner_setRootTest(ITest* pTest)
{
	loc_pRootTest__	= pTest;
}


static ITest*  __ITestRunner_getRootTest()
{
	return loc_pRootTest__;
}

static void __ITestRunner_startTest(ITestListener* self,ITest* test)
{
	ACT_print(".");
}

static void __ITestRunner_endTest(ITestListener* self,ITest* test)
{

}

static void __ITestRunner_addFailure(ITestListener* self,ITest* test,char* msg,int line,char* file)
{
	ACT_print("\n");
	ACT_print(ITest_name(loc_pRootTest__));
	ACT_print(".");
	ACT_print(ITest_name(test));
	{
		char buf[16];
		ACT_print(" (");
		ACT_print(file);
		ACT_print(" ");
		ACT_itoa(line, buf, 10);
		ACT_print(buf);
		ACT_print(") ");
	}
	ACT_print(msg);
	ACT_print("\n");
}



static void __ITestRunner_start(ITestRunner* pme)
{
	ITestResult_Ctor(&result_,NULL);
	ITestResult_init(&result_, (ITestListener*) &testrunner_);
}

static void __ITestRunner_addTest(ITestRunner* pme, ITest* test)
{
	//loc_pRootTest__ = test;
	__ITestRunner_setRootTest(test);
	
	ITest_run(test, &result_);
}

static void __ITestRunner_run(ITestRunner* pme)
{
	/* nothing*/
}
static void __ITestRunner_end(ITestRunner* pme)
{
	char buf[16];
	if (result_.failureCount) {
		ACT_print("\nrun ");
		ACT_itoa(result_.runCount, buf, 10);
		ACT_print(buf);
		ACT_print(" failures ");
		ACT_itoa(result_.failureCount, buf, 10);
		ACT_print(buf);
		ACT_print("\n");
	} else {
		ACT_print("\nOK (");
		ACT_itoa(result_.runCount, buf, 10);
		ACT_print(buf);
		ACT_print(" tests)\n");
	}
}

ITestRunner* ITestRunner_Ctor(ITestRunner* pme)
{
	pme->pvt = &g_ITestRunnerVtbl;
	return pme;
}
