/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef TESTAPP_H
#define TESTAPP_H

/**
@file           TestApp.h

@brief          TestApp main header file  

@par            Description:

@par            PUBLIC CLASSES:  
                N/A
*/
        
/*===============================================================================
INCLUDES AND VARIABLE DEFINITIONS
=============================================================================== */

// Mandatory includes
#if defined(BREW_STATIC_APP)
#include "comdef.h"
#endif
#include "AEEAppGen.h"          // AEEApplet Declaration
#include "AEE.h"                // Standard AEE Declarations
#include "AEEError.h"			// for EUNSUPPORTED message
#include "AEEShell.h"           // AEE Shell Services
#include "AEEMenu.h"
#include "AEEHeap.h"            // AEE Memory Allocation Services, used foy dynamic MALOC
#include "AEEStdLib.h"          // AEE StdLib Services
#include "AEEFile.h"          
//used for static application
#if defined(BREW_STATIC_APP)
#include "AEEModTable.h"		//for loading application
//for classID, this is a temp ID = AEECLSID_MOBIMON + 1
#define  AEECLSID_TESTCXTESTAPP		0x01010FAB
#else 
#include "testcxtest.bid"       //for dynamic app
#endif

#include "testcxtest_res.h"		    //for load string and icon from bar. because we don't use MIF
								//file for static application. we have to load from bar

//API we will test
#include "AEEDisp.h"            
#include "cx.h"

#define     NORESULT        100
#define     PASSED          0
#define     FAILED          1
#define     UNTESTED        2
#define     INSPECT         3
#define     UNSUPPORTED		4

//menu ID passed to event handler
#define USAGE_BENCHMARK_API			100		//API test, it will set API menu
#define USAGE_BENCHMARK_SETTING		500		//API test, it will set API menu

typedef struct tagTestApp TestApp;		//all variable needed in this application

// Following constant defines the delay between successive invocation of
// TestApp benchmark tests.
#define  CALLBACK_DURATION 500  // 500 milli seconds

// size to allcate array or string
// #define TEST_BUF_SIZE 50

// App specific constants
#define  MAX_STRLEN        80

#define AUTOMATIC_TEST 0
#define MANUAL_TEST 1

#define MAX_RES_STRING_BUF_SIZE 256

// Number of times to execute the tests to get the average run time.
// we set it to 1. if you need run many times, reset it. and result will be the average. 
#define NUM_EXECUTION               1

typedef enum _TestAppRunState {
	RUN_STATE_RUNNING,
	RUN_STATE_SHUTDOWN
} TestAppRunState;

// Enumerate the various application states

typedef enum
{
  APP_STATE_NONE,
  APP_STATE_MAINMENU,
  APP_STATE_TESTMENU,
  APP_STATE_HELP,
  APP_STATE_SUMMARY,
  APP_STATE_ABOUT,
  APP_STATE_MAX
} EAppStateType;

// TestApp applet structure
struct tagTestApp
{
  AEEApplet      a;

  EAppStateType         m_eAppState;    // Application State
  TestAppRunState       eRunState;         // Run State of Gunimon App
  
  AEEDeviceInfo  m_di;
  int            m_cLineNum;           // screen line to be written to next

  AEERect        dispRect;				//testing screen
  AEERect       m_rScreenRect;
  
  int            m_nRepeat;			//if we set NUM_EXECUTION more than 1, it will count run times
  boolean        m_IsTestAll;			//if test all API, it is ture
  IMenuCtl *        m_pIMainMenu;		//Main menu to start TestApp
  IMenuCtl *        m_pITestMenu;			//API menu for benchmarking each API
  // prompt 
  IStatic *         m_pIStatic;
  IMenuCtl *        m_pSK; // fix me rename m_pISoftKey



  IFile          *m_pLogFile;
  
  // configuration file
  IFileMgr       *m_pIFileMgr;			//for load file and write log file	
  IFile          *m_pConfigFile;   
  uint16         m_nExecutionNum;  // how many time tests to run, default = 1, run infinitely if set to 0
  uint16         m_nTimerDuration; // interval between callbacks, default = 200 ms
  void           (*EndOfTestCB)( void *pApp );
  boolean        m_bOnline;        // default = OFF       
  boolean        m_bLogging;       // default = ON
  boolean        m_bAutoMode;      // default = OFF

  IHeap          *m_pIHeap;			//for dymanic memory allcate
  int            activeTestSuite;			//the next test to run
  int            m_nCurrentTest; // used for manual tests

  // 
  ITest *       m_pITest;

  //
  ITestSuite*   m_pITestSuite;

  ITestNode*    m_pActiveTestNode;

  ITestResult*  m_pITestResult;
};

void TestApp_displayAutoTest(TestApp *pMe, const char* str);
void TestApp_displayTextLine (TestApp * pMe, char *pszStr);
void TestApp_displayMessage(TestApp* pMe, char *message, boolean top);
void TestApp_endOfTest( TestApp *pMe );

void TestApp_writeLogFile(TestApp* pMe, const char * testInfo, const char * testInfo2, int retval);


extern ITest*   TestWasRun_initUnitTest();

extern ITest*   TestWasRun_initUnitTestSuite(TestApp* pMe);

#endif /* TESTAPP_H */
