/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "cx.h"
#include "cxtestsuite.h"

struct __ITestSuite {
    ITestSuiteVtbl* pvt;
    uint32 m_cRef;
    char name[CX_TEST_NAME_LENGTH];
    ITestList*      m_lstTest__;
    ITestResult*    m_piTestResult;
    int             m_nActiveChildTestIndex;
};


CXRESULT 
_ITestSuite_new(ITestSuite** ppobj);

void 
_ITestSuite_ctor(ITestSuite* pme, ITestSuiteVtbl* pvt);



void 
_ITestSuite_initVtbl(ITestSuiteVtbl* pvt);


CXRESULT 
_ITestSuite_init(ITestSuite* pobj, char * name);


uint32 
_ITestSuite_addRef(ITestSuite* pobj);

uint32 
_ITestSuite_release(ITestSuite* pobj);



void 
_ITestSuite_xtor(ITestSuite* pme);

CXRESULT 
_ITestSuite_queryInterface(ITestSuite* pobj, CXCLSID clsid, void ** ppNew);

char*    _ITestSuite_name(ITestSuite* self);
void     _ITestSuite_run(ITestSuite* self,ITestResult* result);
int      _ITestSuite_countTestCases(ITestSuite* self);
int      _ITestSuite_getChildTestCount(ITestSuite* self);
ITest*      _ITestSuite_getChildTestAt(ITestSuite* pme, int index);
ITest*      _ITestSuite_findTest(ITestSuite* pme, char *pszName);
ITestResult*    _ITestSuite_getTestResult(ITestSuite* pobj);

void            _ITestSuite_setTestResult(ITestSuite* pobj, ITestResult* piTestResult);

void _ITestSuite_addTest(ITestSuite* pme, ITest* pITest);
ITest* _ITestSuite_findName(ITestSuite* self,char * pszName);

ITestNode* TestSuite_getHeadPosition(ITestSuite* pMe);
ITest* TestSuite_getNext(ITestSuite* pMe, ITestNode ** ppTestNode);
ITest* TestSuite_getAt(ITestSuite *pMe, ITestNode* position);
ITestNode* TestSuite_findIndex(ITestSuite *pMe, int nIndex);

int TestSuite_getActiveChildTestIndex(ITestSuite* pMe);
void TestSuite_setActiveChildTestIndex(ITestSuite* pMe, int nIndex);

///////////////////////////////////////////////////////////////////////////////
CXRESULT 
_ITestSuite_new(ITestSuite** ppobj)
{
    CXRESULT result;
    ITestSuite * pme;

    pme = (ITestSuite*) cx_malloc(sizeof(ITestSuite) + sizeof(ITestSuiteVtbl) );

    *ppobj = NULL;

    if(!pme)
    {
        return CX_E_NOMEMORY;
    }
    
    _ITestSuite_ctor(pme, (ITestSuiteVtbl*)(pme+1));
    result = _ITestSuite_init(pme,"");
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestSuite_xtor(pme);
        cx_free(pme);        
    }

    *ppobj = (ITestSuite*)pme;
    
    return result;
    
}

void 
_ITestSuite_ctor(ITestSuite* pme, ITestSuiteVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestSuite_initVtbl(pvt);
    }    
}


void 
_ITestSuite_initVtbl(ITestSuiteVtbl* pvt)
{
    pvt->addRef = _ITestSuite_addRef;
    pvt->release = _ITestSuite_release;
    pvt->queryInterface = _ITestSuite_queryInterface;
    pvt->name = _ITestSuite_name;
    pvt->run = _ITestSuite_run;
    pvt->countTestCases = _ITestSuite_countTestCases;
    pvt->getChildTestCount = _ITestSuite_countTestCases;
    pvt->getChildTestAt = _ITestSuite_getChildTestAt;
    pvt->findTest = _ITestSuite_findTest;
    pvt->getTestResult = _ITestSuite_getTestResult;
    pvt->setTestResult = _ITestSuite_setTestResult;
    
    pvt->addTest = _ITestSuite_addTest;
    pvt->findName = _ITestSuite_findName;
    pvt->init = _ITestSuite_init;

    pvt->getHeadPosition = TestSuite_getHeadPosition;
    pvt->getNext = TestSuite_getNext;
    pvt->getAt = TestSuite_getAt;
    pvt->findIndex = TestSuite_findIndex;

    pvt->getActiveChildTestIndex =
        TestSuite_getActiveChildTestIndex;
    pvt->setActiveChildTestIndex = 
        TestSuite_setActiveChildTestIndex;
}


CXRESULT 
_ITestSuite_init(ITestSuite* pobj, char * name)
{
    ITestSuite * pme;
    pme = (ITestSuite *) pobj;

    cx_strncpy(pme->name, name, CX_TEST_NAME_LENGTH);
    //cx_createInstance(CXCLSID_TESTLIST, (void**) &pme->m_lstTest__);
	ITestList_new(&pme->m_lstTest__);

    pme->m_nActiveChildTestIndex = 0;
    pme->m_piTestResult = NULL;
    return CX_S_OK;
}


uint32 
_ITestSuite_addRef(ITestSuite* pobj)
{
    ITestSuite* pme = (ITestSuite*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestSuite_release(ITestSuite* pobj)
{
    ITestSuite* pme;
    uint32 cRef;

    pme = (ITestSuite*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestSuite_xtor(pme);
        cx_free(pme);
    }
    
    return cRef;
}


void 
_ITestSuite_xtor(ITestSuite* pme)
{
    ITestList_release(pme->m_lstTest__);
}


CXRESULT 
_ITestSuite_queryInterface(ITestSuite* pobj, CXCLSID clsid, void ** ppNew)
{
    CXRESULT result;

    result = CX_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == CXCLSID_UNKNOWN ||
        clsid == CXCLSID_TEST ||
        clsid == CXCLSID_TESTSUITE)
    {
        *ppNew = pobj;
        _ITestSuite_addRef(pobj);
        result = CX_S_OK;
    }
    
    return result;
}


char* _ITestSuite_name(ITestSuite* self)
{
    return self->name;
}

void _ITestSuite_run(ITestSuite* self,ITestResult* result)
{
    ITest* test;
    ITestNode* pNode;
    
    int i;
    int numberOfTests; 
    
    
    if(self->m_lstTest__)
    {
        numberOfTests = ITestList_getCount(self->m_lstTest__);
        pNode = (ITestNode*) ITestList_getHeadPosition(self->m_lstTest__);
        
        for(i = 0; i < numberOfTests; i++)
        {
            test = (ITest*) ITestList_getNext(self->m_lstTest__, &pNode);
            ITest_run(test, result);
        }
    }
}

int _ITestSuite_countTestCases(ITestSuite* self)
{
    ITest* test;
    ITestNode* pNode;
    
    int count = 0;
    int i;
    int numberOfTests; 
    
    if(self->m_lstTest__)
    {
        numberOfTests = ITestList_getCount(self->m_lstTest__);
        pNode = (ITestNode*) ITestList_getHeadPosition(self->m_lstTest__);
        
        for(i = 0; i < numberOfTests; i++)
        {
            test = (ITest*) ITestList_getNext(self->m_lstTest__, &pNode);
            count += ITest_countTestCases(test);
        }
    }
    
    return count;
}

int      _ITestSuite_getChildTestCount(ITestSuite* self)
{
    return ITestList_getCount(self->m_lstTest__);
}


ITest*      _ITestSuite_getChildTestAt(ITestSuite* pme, int index)
{
    ITestNode * pNode;

    pNode = (ITestNode *)ITestList_findIndex(pme->m_lstTest__, index);
    return (ITest *)ITestList_getAt(pme->m_lstTest__, pNode);
}


ITest*      _ITestSuite_findTest(ITestSuite* self, char *pszName)
{
    char* pszTestName;
    ITest* test;
    ITestNode* pNode;
    
    int i;
    int numberOfTests; 
    
    pszTestName = ITestSuite_name(self);
    if( cx_strcmp(pszTestName, pszName) == 0)
    {
        return (ITest*)self;
    }
    
    if(self->m_lstTest__)
    {
        numberOfTests = ITestList_getCount(self->m_lstTest__);
        pNode = (ITestNode*) ITestList_getHeadPosition(self->m_lstTest__);
        
        for(i = 0; i < numberOfTests; i++)
        {
            test = (ITest*) ITestList_getNext(self->m_lstTest__, &pNode);
            pszTestName = ITest_name(test);
            if( cx_strcmp(pszTestName, pszName) == 0)
            {
                return test;
            }
        }
    }    
    return NULL;
}

ITestResult* 
_ITestSuite_getTestResult(ITestSuite* pobj)
{
    ITestSuite *pme;
    pme = (ITestSuite*) pobj;

    return pme->m_piTestResult;    
}

void
_ITestSuite_setTestResult(ITestSuite* pobj, ITestResult* piTestResult)
{
    ITestSuite *pme;
    pme = (ITestSuite*) pobj;

    pme->m_piTestResult = piTestResult;    
}

void _ITestSuite_addTest(ITestSuite* pMe, ITest* pITest)
{
    //    pMe->m_lstTest;
    ITestList_addTail(pMe->m_lstTest__, pITest);
}

ITestNode* TestSuite_getHeadPosition(ITestSuite* pMe)
{
    ITestNode* pTestNode;

    pTestNode = (ITestNode*) ITestList_getHeadPosition(pMe->m_lstTest__);

    return pTestNode;
}

ITest* TestSuite_getNext(ITestSuite* pMe, ITestNode ** ppTestNode)
{
    ITest* pNextTest;

    pNextTest = (ITest*) ITestList_getNext(pMe->m_lstTest__, ppTestNode);

    return pNextTest;
}

ITest* TestSuite_getAt(ITestSuite *pMe, ITestNode* position)
{
    return (ITest*) ITestList_getAt(pMe->m_lstTest__, position);
}

ITestNode* TestSuite_findIndex(ITestSuite *pMe, int nIndex)
{
    return (ITestNode*) ITestList_findIndex(pMe->m_lstTest__, nIndex);
}

ITest* _ITestSuite_findName(ITestSuite* self,char * pszName)
{
    ITest* test;
    ITestNode* pNode;
    char * pszTestName;
    
    int count = 0;
    int i;
    int numberOfTests; 
    
    if(self->m_lstTest__)
    {
        numberOfTests = ITestList_getCount(self->m_lstTest__);
        pNode = (ITestNode*) ITestList_getHeadPosition(self->m_lstTest__);
        
        for(i = 0; i < numberOfTests; i++)
        {
            test = (ITest*) ITestList_getNext(self->m_lstTest__, &pNode);
            pszTestName = ITest_name(test);
            
            if(pszTestName && cx_strcmp(pszName, pszTestName) == 0)
            {
                return test;
            }
        }
   }
    
    return NULL;
}

int TestSuite_getActiveChildTestIndex(ITestSuite* pMe)
{
    return pMe->m_nActiveChildTestIndex;
}

void TestSuite_setActiveChildTestIndex(ITestSuite* pMe, int nIndex)
{
    pMe->m_nActiveChildTestIndex = nIndex;
}

