/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "cx.h"
#include "cxtestlistener.h"
 
struct __ITestListener {
	ITestListenerVtbl* pvt;
    uint32    m_cRef;
};

CXRESULT _ITestListener_new(ITestListener** ppobj);

void 
_ITestListener_ctor(ITestListener* pme, ITestListenerVtbl* pvt);


void 
_ITestListener_initVtbl(ITestListenerVtbl* pvt);


CXRESULT 
_ITestListener_init(ITestListener* pobj);


uint32 
_ITestListener_addRef(ITestListener* pobj);


uint32 
_ITestListener_release(ITestListener* pobj);


void 
_ITestListener_xtor(ITestListener* pme);

CXRESULT 
_ITestListener_queryInterface(ITestListener* pobj, CXCLSID clsid, void ** ppNew);

void _ITestListener_startTest(ITestListener* self,ITest* test);

void _ITestListener_endTest(ITestListener* self,ITest* test);

void _ITestListener_addFailure(ITestListener* self,ITest* test,const char* msg,int line,const char* file);
    
// defined in acttestrunner.c
ITest* _cx_getRootTest();

///////////////////////////////////////////////////////////////////////////////

CXRESULT ITestListener_new(ITestListener** ppobj)
{
    CXRESULT result;
    ITestListener *pme;

    pme = cx_malloc(sizeof(ITestListener)+sizeof(ITestListenerVtbl));

    if(!pme)
    {
        return CX_E_NOMEMORY;
    }

    _ITestListener_ctor(pme, (ITestListenerVtbl*)(pme+1));    
    result = _ITestListener_init(pme);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestListener_xtor(pme);
        cx_free(pme);        
    }

    *ppobj = (ITestListener*)pme;
    
    return result;
    
}

void 
_ITestListener_ctor(ITestListener* pme, ITestListenerVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestListener_initVtbl(pvt);
    }    
}

void 
_ITestListener_initVtbl(ITestListenerVtbl* pvt)
{
    pvt->addRef = _ITestListener_addRef;
    pvt->release = _ITestListener_release;
    pvt->queryInterface = _ITestListener_queryInterface;
    pvt->startTest = (TestListenerStartTestCallBack)_ITestListener_startTest;
    pvt->endTest = (TestListenerEndTestCallBack)_ITestListener_endTest;
    pvt->addFailure = (TestListenerAddFailureCallBack)_ITestListener_addFailure;
}


CXRESULT 
_ITestListener_init(ITestListener* pobj)
{
    ITestListener * pme;
    pme = (ITestListener *) pobj;
    
    return CX_S_OK;
}


uint32 
_ITestListener_addRef(ITestListener* pobj)
{
    ITestListener* pme = (ITestListener*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestListener_release(ITestListener* pobj)
{
    ITestListener* pme;
    uint32 cRef;

    pme = (ITestListener*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestListener_xtor(pme);
        cx_free(pme);
    }
    
    return cRef;
}


void 
_ITestListener_xtor(ITestListener* pme)
{
}


CXRESULT 
_ITestListener_queryInterface(ITestListener* pobj, CXCLSID clsid, void ** ppNew)
{
    CXRESULT result;

    result = CX_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == CXCLSID_UNKNOWN ||
        clsid == CXCLSID_TESTLISTENER)
    {
        *ppNew = pobj;
        _ITestListener_addRef(pobj);
        result = CX_S_OK;
    }
    
    return result;
}

void _ITestListener_startTest(ITestListener* self,ITest* test)
{
    cx_print(".");
}

void _ITestListener_endTest(ITestListener* self,ITest* test)
{
    
}

void _ITestListener_addFailure(ITestListener* self,ITest* test,const char* msg,int line,const char* file)
{
    cx_print("\n");
    //cx_print(ITest_name(_cx_getRootTest()));
    cx_print(".");
    cx_print(ITest_name(test));
    {
        char buf[16];
        cx_print(" (");
        cx_print(file);
        cx_print(" ");
        cx_itoa(line, buf, 10);
        cx_print(buf);
        cx_print(") ");
    }
    cx_print(msg);
    cx_print("\n");
}
