/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__CXTESTSUITE_H__
#define	__CXTESTSUITE_H__
#ifdef	__cplusplus
extern "C" {
#endif

typedef struct __ITestNode ITestNode;

typedef struct __ITestSuite	ITestSuite;

typedef struct __ITestSuiteVtbl ITestSuiteVtbl;

struct __ITestSuiteVtbl
{
///    ITestVtbl super_;
    uint32 (* addRef) (ITestSuite* pobj);
    uint32 (* release) (ITestSuite* pobj);
    CXRESULT (*queryInterface)(ITestSuite* pobj, CXCLSID clsid, void ** ppNew);
    char* (*name)(ITestSuite* pobj);
    void (*run)(ITestSuite* pobj, ITestResult* pResult);
    int  (*countTestCases)(ITestSuite* pobj);
    int  (*getChildTestCount)(ITestSuite* pobj);
    ITest* (*getChildTestAt)(ITestSuite* pobj, int index);
    ITest* (*findTest)(ITestSuite* pobj, char *name);
    ITestResult*    (*getTestResult)(ITestSuite* pobj);
    void            (*setTestResult)(ITestSuite* pobj, ITestResult* piTestResult);

    void(*addTest)(ITestSuite* pme, ITest* pITest);
    ITest* (*findName)(ITestSuite* pme,char * pszName);
    CXRESULT (*init)(ITestSuite* pme,char * pszName);

    ITestNode*  (* getHeadPosition)(ITestSuite *pMe);
    ITest*      (* getNext)(ITestSuite *pMe, ITestNode** lppPosition);
    ITest*      (* getAt)(ITestSuite* pMe, ITestNode* position);
    ITestNode*  (* findIndex)(ITestSuite* pMe, int nIndex);

    int         (* getActiveChildTestIndex)(ITestSuite* pMe);
    void        (* setActiveChildTestIndex)(ITestSuite* pMe, int nIndex);
};


//ITestSuite* ITestSuite_New(char* name);
//ITestSuite* ITestSuite_Ctor(ITestSuite* pme, char* name, int numberOfTests, ITest** tests);
//ITestSuite* ITestSuite_Ctor(ITestSuite* pme, char* name);
#define ITestSuite_addRef(pobj)             (*(ITestSuiteVtbl**)pobj)->addRef(pobj)
#define ITestSuite_release(pobj)            (*(ITestSuiteVtbl**)pobj)->release(pobj)
#define ITestSuite_queryInterface(po,id,ppn) (*((ITestSuiteVtbl**)po))->queryInterface(po,id,ppn)
#define ITestSuite_name(pobj)               (*(ITestSuiteVtbl**)pobj)->name(pobj)
#define ITestSuite_run(pobj,r)              (*(ITestSuiteVtbl**)pobj)->run(pobj,r)
#define ITestSuite_countTestExCases(pobj)   (*(ITestSuiteVtbl**)pobj)->countTestCases(pobj)
#define ITestSuite_getChildTestCount(pobj)  (*(ITestSuiteVtbl**)pobj)->getChildTestCount(pobj)
#define ITestSuite_getChildTestAt(pobj,i)   (*(ITestSuiteVtbl**)pobj)->getChildTestAt(pobj,i)
#define ITestSuite_findTest(pobj,n)         (*(ITestSuiteVtbl**)pobj)->findTest(pobj,n)
#define ITestSuite_getTestResult(pobj)           (*(ITestSuiteVtbl**)pobj)->getTestResult(pobj)
#define ITestSuite_setTestResult(pobj, pResult)  (*(ITestSuiteVtbl**)pobj)->setTestResult(pobj,pResult)

#define ITestSuite_addTest(pobj, pITest)    (*(ITestSuiteVtbl**)pobj)->addTest(pobj, pITest)
#define ITestSuite_findName(pobj, pName)    (*(ITestSuiteVtbl**)pobj)->findName(pobj, pName)
#define ITestSuite_init(pobj, pName)        (*(ITestSuiteVtbl**)pobj)->init(pobj, pName)

#define ITestSuite_getHeadPosition(pobj)        (*(ITestSuiteVtbl**)pobj)->getHeadPosition(pobj)
#define ITestSuite_getNext(pobj, lppPosition)   (*(ITestSuiteVtbl**)pobj)->getNext(pobj, lppPosition)
#define ITestSuite_getAt(pobj, position)    (*(ITestSuiteVtbl**)pobj)->getAt(pobj, position)
#define ITestSuite_findIndex(pobj, nIndex)  (*(ITestSuiteVtbl**)pobj)->findIndex(pobj, nIndex) 

#define ITestSuite_getActiveChildTestIndex(pobj) (*(ITestSuiteVtbl**)pobj)->getActiveChildTestIndex(pobj) 
#define ITestSuite_setActiveChildTestIndex(pobj, nIndex) (*(ITestSuiteVtbl**)pobj)->setActiveChildTestIndex(pobj, nIndex) 

CXRESULT 
_ITestSuite_new(ITestSuite** ppobj);
#ifdef	__cplusplus
}
#endif
#endif/*__CXTESTSUITE_H__*/

