#ifndef __CXTESTRUNNER_H__
#define __CXTESTRUNNER_H__

typedef struct __ITest				ITest;

typedef struct __ITestRunner        ITestRunner;
typedef struct __ITestRunnerVtbl    ITestRunnerVtbl;
struct __ITestRunnerVtbl 
{
    uint32		(*addRef)(ITestRunner* po);
    uint32		(*release)(ITestRunner* po);
    CXRESULT	(*queryInterface)(ITestRunner* pobj, CXCLSID clsid, void ** ppNew);
    
    void (*start)(ITestRunner* po);
    void (*addTest)(ITestRunner* po, ITest* test);
    void (*runTest)(ITestRunner* po);
	void (*end)(ITestRunner*po);
};

#define ITestRunner_addRef(pobj)         (*(ITestRunnerVtbl**)pobj)->addRef(pobj)
#define ITestRunner_release(pobj)         (*(ITestRunnerVtbl**)pobj)->release(pobj)
#define ITestRunner_queryInterface(po,id,ppn) (*((ITestRunnerVtbl**)po))->queryInterface(po,id,ppn)

#define ITestRunner_start(po)           (*(ITestRunnerVtbl**)po)->start(po)
#define ITestRunner_addTest(po,test)    (*(ITestRunnerVtbl**)po)->addTest(po,test)
#define ITestRunner_runTest(po)         (*(ITestRunnerVtbl**)po)->runTest(po)
#define ITestRunner_end(po)             (*(ITestRunnerVtbl**)po)->end(po)

CXRESULT 
ITestRunner_new(void** ppobj);

#endif /* __CXTESTRUNNER_H__ */