/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__CXTESTCALLER_H__
#define	__CXTESTCALLER_H__

typedef struct __ITestFixture		ITestFixture;
typedef struct __ITestCaller		ITestCaller;

typedef struct __ITestCallerVtbl	ITestCallerVtbl;

struct __ITestCallerVtbl 
{
    uint32 (* addRef) (ITestCaller* pobj);
    uint32 (* release) (ITestCaller* pobj);
    CXRESULT (*queryInterface)(ITestCaller* pobj, CXCLSID clsid, void ** ppNew);
    char* (*name)(ITestCaller* pobj);
    void (*run)(ITestCaller* pobj, ITestResult* pResult);
    int  (*countTestCases)(ITestCaller* pobj);
    int  (*getChildTestCount)(ITestCaller* pobj);
    ITest* (*getChildTestAt)(ITestCaller* pobj, int index);
    ITest* (*findTest)(ITestCaller* pobj, char *name);

    CXRESULT (*init)(ITestCaller* pobj, char * name, PFNSETUP setup, PFNTEARDWON tdw);
    void (*addTestFixture)(ITestCaller* pme, ITestFixture* fixture);
};

#define ITestCaller_addRef(pobj)         (*(ITestCallerVtbl**)pobj)->addRef(pobj)
#define ITestCaller_release(pobj)         (*(ITestCallerVtbl**)pobj)->release(pobj)
#define ITestCaller_queryInterface(po,id,ppn) (*((ITestCallerVtbl**)po))->queryInterface(po,id,ppn)
#define ITestCaller_name(pobj)           (*(ITestCallerVtbl**)pobj)->name(pobj)
#define ITestCaller_run(pobj,r)          (*(ITestCallerVtbl**)pobj)->run(pobj,r)
#define ITestCaller_countTestCases(pobj) (*(ITestCallerVtbl**)pobj)->countTestCases(pobj)
#define ITestCaller_getChildTestCount(pobj) (*(ITestCallerVtbl**)pobj)->getChildTestCount(pobj)
#define ITestCaller_getChildTestAt(pobj,i) (*(ITestCallerVtbl**)pobj)->getChildTestAt(pobj,i)
#define ITestCaller_findTest(pobj,n) (*(ITestCallerVtbl**)pobj)->findTest(pobj,n)

#define ITestCaller_init(pobj, n, s, t) (*(ITestCallerVtbl**)pobj)->init(pobj, n, s, t)
#define ITestCaller_addTestFixture(pobj, fixture) (*(ITestCallerVtbl**)pobj)->addTestFixture(pobj, fixture)

CXRESULT 
_ITestCaller_new(ITestCaller** ppobj);

#endif/*__CXTESTCALLER_H__*/

