/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__CXHELPERMACRO_H__
#define	__CXHELPERMACRO_H__
#ifdef	__cplusplus
extern "C" {
#endif
#ifdef __CXTESTCASE_H__

#define CX_TESTCASE_NEW(pTestCase,name,sup,tdw,run) \
    ITestCase_new(&pTestCase);\
    ITestCase_init(pTestCase,name,sup,tdw,run)

#define CX_TESTCASE_DELETE(pTestCase) \
    ITestCase_release(pTestCase)

#endif /* __CXTESTCASE_H__ */


#ifdef __CXTESTRESULT_H__

#define CX_TESTRESULT_NEW(pTestResult, pListener) \
    _ITestResult_new(&pTestResult); \
    ITestResult_init(pTestResult, pListener)

#define CX_TESTRESULT_DELETE(pTestResult) \
    ITestResult_release(pTestResult)

#endif /* __CXTESTRESULT_H__   */


#ifdef __CXTESTSUITE_H__

#define CX_TESTSUITE_NEW(pTestSuite,name) \
    _ITestSuite_new(&pTestSuite);\
    ITestSuite_init(pTestSuite,name)

#define CX_TESTSUITE_DELETE(pTestSuite) \
    ITestSuite_release(pTestSuite)

#define CX_ADD_TEST(pTestSuite, pTest) \
    ITestSuite_addTest(pTestSuite, pTest)

#endif /* __CXTESTSUITE_H__ */


#ifdef __CXTESTCALLER_H__

#define CX_TESTCALLER_NEW(pCaller_, name_, setUp_, tearDown_) \
    _ITestCaller_new(&pCaller_);\
    ITestCaller_init(pCaller_, name_,setUp_,tearDown_);

#define CX_TESTCALLER_DELETE(pCaller_) \
     ITestCaller_release(pCaller_)

#define CX_ADD_FIXTURE(pCaller_, name_, pfnTest_) \
do {\
    ITestFixture * pFixture; \
    _ITestFixture_new(&pFixture); \
    ITestFixture_init(pFixture, name_, pfnTest_); \
    ITestCaller_addTestFixture(pCaller_,pFixture); \
} while(0) 

#endif /* __CXTESTCALLER_H__ */


#ifdef __CXTESTREPEAT_H__

#define CX_TESTREPEAT_NEW(repeater_,test_,tmrp_) \
    _ITestRepeat_new(&repeater_);\
    ITestRepeat_init(repeater_, test_,tmrp_);


#define CX_TESTREPEAT_DELETE(repeater_) \
     ITestRepeat_release(repeater_)

#endif /* __CXTESTREPEAT_H__ */


#ifdef __CXTESTRUNNER_H__

#define CX_TESTRUNNER_NEW(runner_) \
    ITestRunner_new(&runner_);

#define CX_TESTRUNNER_DELETE(runner_) \
    ITestRunner_release(runner_)

#endif /* __CXTESTRUNNER_H__ */


#define CX_TESTRUNNERMFC_NEW(runner_) \
     _ITestRunnerMfc_new(&runner_)

#define CX_TESTRUNNERMFC_DELETE(runner_) \
    ITestRunnerMfc_release(runner_)

#ifdef	__cplusplus
}
#endif
#endif /* __CXHELPERMACRO_H__ */

