/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __CXASSERTIMPL_H__
#define __CXASSERTIMPL_H__

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct __ITest ITest;

void cx_addFailure(ITest *pme, const char *msg, long line, const char *file);	/*TestCase.c*/

void cx_assertImplementationInt(ITest *pme, int expected,int actual, long line, const char *file);
void cx_assertImplementationCStr(ITest *pme, const char *expected,const char *actual, long line, const char *file);

#define CXTEST_ASSERT_EQUAL_STRING(p, expected,actual)\
	if (expected && actual && (cx_strcmp(expected,actual)==0)) \
	{} \
	else {\
	cx_assertImplementationCStr(p, expected,actual,__LINE__,__FILE__);\
	return;}

#define CXTEST_ASSERT_EQUAL_INT(p, expected,actual)\
	if (expected == actual) \
	{} \
	else {\
	cx_assertImplementationInt(p, expected,actual,__LINE__,__FILE__);\
	return;}

#define CXTEST_ASSERT_NULL(p, pointer)\
	CXTEST_ASSERT_MESSAGE(p, pointer == NULL,#pointer " was not null.")

#define CXTEST_ASSERT_NOT_NULL(p, pointer)\
	CXTEST_ASSERT_MESSAGE(p, pointer != NULL,#pointer " was null.")

#define CXTEST_ASSERT_MESSAGE(p, condition, message)\
	if (condition) \
	{}\
	 else {\
	CXTEST_FAIL(p, message);}

#define CXTEST_ASSERT(p, condition)\
	if (condition) \
	{} \
	else {\
	CXTEST_FAIL(p, #condition);}

#define CXTEST_FAIL(p, message)\
	if (0)\
	{} \
	else {\
	cx_addFailure(p, message,__LINE__,__FILE__);\
	return;}

#ifdef	__cplusplus
}
#endif

#endif /* __CXTESTASSERT_H__ */

